/*
 *	spTopLevel.h
 */

#ifndef __SPTOPLEVEL_H
#define __SPTOPLEVEL_H

#include <sp/spObject.h>

#ifdef __cplusplus
extern "C" {
#endif

#define SpTopLevel "TopLevel"
    
#define SppLanguage "SLanguage"		/* CG */
#define SppIconName "SIconName"		/* CG */
#define SppInformation "SInformation"	/* CSG */
#define SppAltCtrlSwap "bAltCtrlSwap"	/* CSG */
#define SppExitPrompt "bExitPrompt"	/* CSG */
#define SppThreadSafe "bThreadSafe"	/* CG */
#define SppResources "LResources"	/* CG; internal use only */    

/* version 0.6.5+ */    
#define SppUseWindowMenu "bUseWindowMenu"	/* CG; use "window" menu on supported OSs */

/* version 0.6.6+ */    
#define SppUniqueApplicationId "SUniqueApplicationId"	/* CG; to prevent from dupicated execution like Mac OS */
/* not supported yet */    
#define SppClosePrompt "bClosePrompt" 	/* CSG */
#define SppModifiedClosePrompt "bModifiedClosePrompt" /* CSG */

/* version 0.6.19+ */    
#define SppTopLevelCallbackFunc "FTopLevelCallbackFunc" /* CSG */
#define SppTopLevelCallbackData "PTopLevelCallbackData" /* CSG */

/* version 0.6.20+ */    
#define SppPermissions "lPermissions"		/* CSG */
#define SppAcceptedPermissions "lAcceptedPermissions"		/* G */
#define SppDisabledPermissions "lDisabledPermissions"		/* G */
#define SppAskedPermissions "lAskedPermissions"		/* G */

/* version 0.6.22+ */    
#define SppApplicationDomainId "SApplicationDomainId" /* CG; such as "appname.example.com" */

#define SP_PERMISSION_NONE 0
#define SP_PERMISSION_READ_EXTERNAL_STORAGE (1L<<0)
#define SP_PERMISSION_WRITE_EXTERNAL_STORAGE (1L<<1)
#define SP_PERMISSION_RECORD_AUDIO (1L<<2)
#define SP_PERMISSION_CAPTURE_AUDIO_OUTPUT (1L<<3)
#define SP_PERMISSION_CAMERA (1L<<4)
#define SP_PERMISSION_BODY_SENSORS (1L<<6)
#define SP_PERMISSION_ACCESS_FINE_LOCATION (1L<<12)
#define SP_PERMISSION_ACCESS_COARSE_LOCATION (1L<<13)
#define SP_PERMISSION_READ_CALENDAR (1L<<14)
#define SP_PERMISSION_WRITE_CALENDAR (1L<<15)
#define SP_PERMISSION_READ_CONTACTS (1L<<16)
#define SP_PERMISSION_WRITE_CONTACTS (1L<<17)
#define SP_PERMISSION_GET_ACCOUNTS (1L<<18)

typedef enum {
    SP_TL_CR_NONE = -1,
    SP_TL_CR_UNKNOWN = 0,
    SP_TL_CR_ACTIVE = 1,
    SP_TL_CR_INACTIVE = 2,
    SP_TL_CR_TERMINATE = 3,
    
    SP_TL_CR_PERMISSION_REQUEST = 16,
    SP_TL_CR_PERMISSION_CHANGED = 17, /* return SP_FALSE: application exits */
    SP_TL_CR_PERMISSION_RATIONALE_ASKED = 18, /* return SP_FALSE: the permission request will be skipped */
} spTopLevelCallbackReason;

typedef struct _spTopLevelRec *spTopLevel;
typedef struct _spTopLevelClassRec *spTopLevelClass;

typedef spBool (*spTopLevelCallbackFunc)(spTopLevel toplevel, spTopLevelCallbackReason reason, void *call_data);

#if defined(MACOS)
#pragma import on
#endif

extern void spQuit(int status);
extern int spWaitNextEvent(spTopLevel toplevel);
extern int spDispatchEvent(spTopLevel toplevel);
extern int spMainLoop(spTopLevel toplevel);
extern spTopLevel spInitializeArg(int *argcp, char ***argvp, spArg *args, int num_arg);
extern spTopLevel spInitialize(int *argcp, char ***argvp, ...);
extern spBool spSetTopLevelParamsArg(spTopLevel toplevel, spArg *args, int num_arg);
extern spBool spGetTopLevelParamsArg(spTopLevel toplevel, spArg *args, int num_arg);
extern spBool spSetTopLevelParams(spTopLevel toplevel, ...);
extern spBool spGetTopLevelParams(spTopLevel toplevel, ...);
extern spBool spIsTopLevelCreated(void);
extern spBool spIsThreadSafe(void);
extern void spThreadEnter(void);
extern void spThreadLeave(void);
extern spBool spSuspendMainLock(spBool flag);
extern spBool spResumeMainLock(spBool flag);
extern long spWaitThreadLoop(spTopLevel toplevel, void *handle);
    
extern spBool spIsPostEventSupported(spTopLevel toplevel);

extern unsigned long spGetAcceptedPermissions(spTopLevel toplevel);
extern unsigned long spGetDisabledPermissions(spTopLevel toplevel);
extern spBool spDemandPermissionRequest(spTopLevel toplevel, unsigned long permissions);
extern spBool spIsPermissionRequestRequired(spTopLevel toplevel, unsigned long permissions);

extern int spScaleX(int x);
extern int spScaleY(int y);
extern int spUnscaleX(int x);
extern int spUnscaleY(int y);

/* 0.6.21+, internal use only */
extern void *spGetTopLevelInternalCallbackData(spTopLevel toplevel);

#if defined(MACOS)
#pragma import off
#endif

#ifdef __cplusplus
}  /* Close scope of 'extern "C"' declaration */
#endif

#endif /* __SPTOPLEVEL_H */
