LOCAL_PATH := $(call my-dir)

SP_INCLUDE_TOP := $(LOCAL_PATH)/../../../../../include
SP_BASE_TOP := $(LOCAL_PATH)/../../../../../spBase
SP_BASE_LIB_LOCAL := $(LOCAL_PATH)/../../../../../spBase/android/obj/local
SP_COMPONENT_TOP := $(LOCAL_PATH)/../../../../../spComponent
SP_COMPONENT_ANDROID_TOP := $(LOCAL_PATH)/../../../../../spComponent
SP_COMPONENT_LIB_LOCAL := $(SP_COMPONENT_ANDROID_TOP)/android/obj/local

include $(CLEAR_VARS)

LOCAL_MODULE    := check_box
LOCAL_SRC_FILES := check_box.c 

ifeq ($(TARGET_ARCH_ABI),arm64-v8a)
LOCAL_CFLAGS += -ffast-math
endif
ifeq ($(TARGET_ARCH_ABI),armeabi-v7a)
LOCAL_ARM_MODE  := arm
LOCAL_ARM_NEON  := false
endif
ifeq ($(TARGET_ARCH_ABI),armeabi-v7a-hard)
LOCAL_ARM_MODE  := arm
LOCAL_ARM_NEON  := true
LOCAL_CFLAGS += -ffast-math
endif

SP_BASE_LIB_TOP := $(SP_BASE_LIB_LOCAL)/$(TARGET_ARCH_ABI)
SP_COMPONENT_LIB_TOP := $(SP_COMPONENT_LIB_LOCAL)/$(TARGET_ARCH_ABI)

LOCAL_C_INCLUDES := $(SP_INCLUDE_TOP) $(SP_BASE_TOP)  $(SP_COMPONENT_TOP) $(SP_COMPONENT_ANDROID_TOP)
LOCAL_CFLAGS += -DANDROID -DHAVE_PTHREAD $(LOCAL_C_INCLUDES:%=-I%)
LOCAL_LDLIBS := -L$(SP_BASE_LIB_TOP) -L$(SP_COMPONENT_LIB_TOP) -L$(SYSROOT)/usr/lib -lspc -lspb -ldl -llog -ljnigraphics

ifeq ($(TARGET_ARCH_ABI),armeabi-v7a-hard)
LOCAL_LDLIBS += -lm_hard
endif

include $(BUILD_SHARED_LIBRARY)
