#include <stdio.h>
#include <sp/spBaseLib.h>
#include <sp/spComponentLib.h>

#include <sp/spMain.h>

static spBool help_flag = SP_FALSE;
static int debug_level = -1;

static spOptions options;
static spOption option[] = {
    {"-debug", NULL, "debug level", NULL,
         SP_TYPE_INT, &debug_level, NULL},
    {"-h", "-help", "display this message", NULL,
         SP_TYPE_BOOLEAN, &help_flag, SP_FALSE_STRING},
};

static char *filelabel[] = {
    "<input file>",
    "<output file>",
};

int spMain(int argc, char *argv[])
{
    const char *input_file;
    const char *output_file;
    spTopLevel toplevel;
    spDIBitmap dibitmap;

    toplevel = spInitialize(&argc, &argv, NULL);
    
    /* get command line options */
    spSetHelpMessage(&help_flag, "Bitmap File Converter");
    options = spGetOptions(argc, argv, option, filelabel);
    spGetOptionsValue(argc, argv, options);
    spSetDebugLevel(debug_level);
    spCheckNumFile(options);

    input_file = spGetFile(options);
    output_file = spGetFile(options);
    
    fprintf(stderr, "Input File: %s\n", input_file);
    fprintf(stderr, "Output File: %s\n", output_file);
    
    /* load bitmap file */
    if ((dibitmap = spCreateDIBitmapFromFileNonnative(input_file)) != NULL) {
        spDebug(10, "spMain", "width = %ld, height = %ld\n", dibitmap->info.width, dibitmap->info.height);

        if (spSaveDIBitmapWithInfo(dibitmap, output_file, spGetDIBitmapFileInfo(dibitmap), 0L) == SP_FALSE) {
            fprintf(stderr, "Cannot save as a file: %s\n", output_file);
            spQuit(1);
        }
    } else {
        fprintf(stderr, "Cannot open bitmap file: %s\n", input_file);
        spQuit(1);
    }

    spQuit(0);
    
    return 0;
}
