#include <stdio.h>
#include <sp/spBaseLib.h>
#include <sp/spComponentLib.h>
#include <sp/spComponentMain.h>

static spComponent canvas = NULL;
static spGraphics graphics = NULL;
static char current_color[SP_MAX_LINE] = "white";

static void canvasCB(spComponent component, void *data)
{
    int width = 0, height = 0;
    
    if (spGetSize(canvas, &width, &height) == SP_FALSE) return;
    
    spDebug(20, "canvasCB", "width = %d, height = %d\n", width, height);

    if (data != NULL) {
        spStrCopy(current_color, sizeof(current_color), data);
    }

    spSetGraphicsParams(graphics, SppForeground, current_color, NULL);
    spFillRectangle(canvas, graphics, 0, 0, width, height);

    spSetGraphicsParams(graphics, SppForeground, "black", NULL);
    spDrawLine(canvas, graphics, 0, 0, width, height);
    spDrawLine(canvas, graphics, width, 0, 0, height);
    
    spRefreshCanvas(canvas);
    
    spDebug(20, "canvasCB", "done\n");
    
    return;
}

int spMain(int argc, char *argv[])
{
    spTopLevel toplevel;
    spComponent frame;
    spComponent menu, menu_bar;

    /* initialize toolkit */
    toplevel = spInitialize(&argc, &argv, NULL);
    
    /* create main window */
    frame = spCreateMainFrame("Capture Canvas", NULL);

    /* create menu bar */
    menu_bar = spCreateMenuBar(frame, "menuBar", NULL);
    
    /* create menu */
    menu = spCreatePulldownMenu(menu_bar, "fileMenu",
                                SppTitle, "File",
                                NULL);
    
    /* add menu item */
    spAddMenuItem(menu, SP_QUIT_MENU_ITEM_NAME,
                  SppCallbackFunc, spQuitCB,
                  SppTitle, "Quit",
                  SppShortcut, "A-q",
                  NULL);

    /* create canvas */
    canvas = spCreateCanvas(frame, "canvas", 300, 300,
                            SppBorderOn, SP_TRUE,
                            SppCallbackFunc, canvasCB,
                            NULL);
    spSetCanvasCapture(canvas, SP_TRUE);

    /* create popup menu */
    menu = spCreatePopupMenu(canvas, "Menu",
                             SppPopupButton, SP_RBUTTON,
                             NULL);
    spAddMenuItem(menu, "To Red",
                  SppCallbackFunc, canvasCB,
                  SppCallbackData, "red",
                  SppShortcut, "C-r",
                  NULL);
    spAddMenuItem(menu, "To Green",
                  SppCallbackFunc, canvasCB,
                  SppCallbackData, "green",
                  SppShortcut, "C-g",
                  NULL);
    spAddMenuItem(menu, "To Blue",
                  SppCallbackFunc, canvasCB,
                  SppCallbackData, "blue",
                  SppShortcut, "C-b",
                  NULL);
    spAddMenuItem(menu, "To White",
                  SppCallbackFunc, canvasCB,
                  SppCallbackData, "white",
                  SppShortcut, "C-w",
                  NULL);

    graphics = spCreateGraphics("graphics1",
                                SppLineType, SP_LINE_DASH_DOT,
                                SppLineWidth, 1,
                                NULL);
    
    /* popup window */
    spPopupWindow(frame);
    
    /* main loop */
    return spMainLoop(toplevel);
}
