#include <stdio.h>
#include <sp/spBaseLib.h>
#include <sp/spComponentLib.h>
#include <sp/spComponentMain.h>

static void checkBoxCB(spComponent component, int num)
{
    spBool set;
    
    if (spGetToggleState(component, &set)) {
        if (set == SP_TRUE) {
            spDisplayMessage(component, NULL, "Check Box %d: Checked", num);
        } else {
            spDisplayMessage(component, NULL, "Check Box %d: Unchecked", num);
        }
    }
    
    return;
}

int spMain(int argc, char *argv[])
{
    spTopLevel toplevel;
    spComponent frame;

    /* initialize toolkit */
    toplevel = spInitialize(&argc, &argv, NULL);
    
    /* create main window */
    frame = spCreateMainFrame("Check Box", NULL);

    /* create check box */
    spCreateCheckBox(frame, "Box 1",
                     SppCallbackFunc, checkBoxCB,
                     SppCallbackData, 1,
                     NULL);
    spCreateCheckBox(frame, "Box 2",
                     SppCallbackFunc, checkBoxCB,
                     SppCallbackData, 2,
                     SppSet, SP_TRUE,
                     NULL);
    spCreateCheckBox(frame, "Box 3",
                     SppCallbackFunc, checkBoxCB,
                     SppCallbackData, 3,
                     NULL);

    /* popup window */
    spPopupWindow(frame);
    
    /* main loop */
    return spMainLoop(toplevel);
}
