#include <stdio.h>
#include <sp/spBaseLib.h>
#include <sp/spComponentLib.h>
#include <sp/spComponentMain.h>

static spBool editable = SP_TRUE;
static spComponent combo_box = NULL;
static spComponent combo_box2 = NULL;
static spComponent label = NULL;

static void resetCombo1CB(spComponent component, void *data)
{
    spSetTextString(combo_box, "This is combo box.");
    return;
}

static void resetCombo2CB(spComponent component, void *data)
{
    spSelectListItem(combo_box2, "Item 7");
    return;
}

static void comboBoxCB(spComponent component, void *data)
{
    char *string;

    spDebug(10, "comboBoxCB", "in\n");
    
    if ((string = xspGetTextString(component)) != NULL) {
        printf("reason = %d: %s\n", spGetCallbackReason(component), string);
        spSetParams(label, SppTitle, string, NULL);
        xspFree(string);
    }
    
    return;
}

static void checkCB(spComponent component, void *data)
{
    if (spGetToggleState(component, &editable) == SP_TRUE) {
        printf("reason = %d: check: %d\n", spGetCallbackReason(component), editable);
        spSetParams(combo_box,
                    SppEditable, editable,
                    NULL);
    }

    return;
}

static void addListItems(spComponent component)
{
    spAddListItem(component, "");
    spAddListItem(component, "Item 1");
    spAddListItem(component, "Item 2");
    spAddListItem(component, "Item 3");
    spAddListItem(component, "Item 4");
    spAddListItem(component, "Item 5");
    spAddListItem(component, "Item 6");
    spAddListItem(component, "Item 7");
    spAddListItem(component, "Item 8");
    spAddListItem(component, "Item 9");
    spAddListItem(component, "Item 10");
    spAddListItem(component, "Item 11");
    spAddListItem(component, "Item 12");
    spAddListItem(component, "Item 13");
    spAddListItem(component, "Item 14");
    spAddListItem(component, "Item 15");
    
    return;
}

int spMain(int argc, char *argv[])
{
    spTopLevel toplevel;
    spComponent frame;
    spComponent menu_bar, menu;

    /*spSetDebugLevel(80);*/

    /* initialize toolkit */
    toplevel = spInitialize(&argc, &argv, NULL);
    
    /* create main window */
    frame = spCreateMainFrame("Combo Box", NULL);

    /* create menu bar */
    menu_bar = spCreateMenuBar(frame, "menuBar",
                               SppTitle, "Menu Bar",
                               NULL);
    
    /* create menu */
    menu = spCreatePulldownMenu(menu_bar, "Menu", NULL);
    
    /* add menu item */
    spAddMenuItem(menu, "Reset Combo 1",
                  SppCallbackFunc, resetCombo1CB,
                  NULL);
    spAddMenuItem(menu, "Reset Combo 2",
                  SppCallbackFunc, resetCombo2CB,
                  NULL);
    
    /* add menu item */
    spAddMenuItem(menu, "Quit",
                  SppCallbackFunc, spQuitCB,
                  SppShortcut, "A-q",
                  NULL);

    /* create check box */
    spCreateCheckBox(frame, "Editable",
                     SppSet, editable,
                     SppCallbackFunc, checkCB,
                     NULL);

    /* create combo box */
    combo_box = spCreateComboBox(frame, "comboBox",
                                 SppCallbackFunc, comboBoxCB,
                                 SppTextString, "This is combo box.",
                                 SppEditable, editable,
                                 NULL);
    addListItems(combo_box);

    /* create select-only combo box */
    combo_box2 = spCreateComboBox(frame, "comboBox2",
                                  SppCallbackFunc, comboBoxCB,
                                  SppSelectOnly, SP_TRUE,
                                  NULL);
    addListItems(combo_box2);

    /* create label */
    label = spCreateLabel(frame, "label",
                          SppAlignment, SP_ALIGNMENT_CENTER,
                          SppInitialWidth, 200,
                          SppTitle, "",
                          NULL);
    
    /* popup window */
    spPopupWindow(frame);
    
    /* main loop */
    return spMainLoop(toplevel);
}
