#include <stdio.h>
#include <sp/spBaseLib.h>
#include <sp/spComponentLib.h>
#include <sp/spComponentMain.h>

static void sizeCB(spComponent component, void *data)
{
    spComponent window;
    int width, height;
    int incr = (int)data;

    spDebug(10, "sizeCB", "in\n");
    
    window = spGetWindow(component);

    if (spGetComponentSize(window, &width, &height) == SP_TRUE) {
        spDebug(10, "sizeCB", "width = %d, height = %d, incr = %d\n", width, height, incr);
        spSetComponentSize(window, width + spScaleX(incr), height);
    }
    
    return;
}

int spMain(int argc, char *argv[])
{
    spTopLevel toplevel;
    spComponent frame;
    spComponent container;

    /*spSetDebugLevel(60);*/
    
    /* initialize toolkit */
    toplevel = spInitialize(&argc, &argv, NULL);
    
    /* create main window */
    frame = spCreateMainFrame("Container", NULL);

    /* create container */
    container = spCreateBox(frame, "Container 1", -3 * spGetButtonDefaultHeight(SP_TRUE),
                            SppOrientation, SP_HORIZONTAL,
                            SppBorderOn, SP_TRUE,
                            SppTitleOn, SP_TRUE,
                            NULL);

    /* create push button */
    spCreatePushButton(container, "Button1",
                       SppSpacingOn, SP_FALSE,
                       SppCallbackFunc, spDisplayMessageCB,
                       SppCallbackData, "Button1 clicked.",
                       SppWidth, -200,
                       NULL);
    spCreatePushButton(container, "Button2",
                       SppCallbackFunc, spDisplayMessageCB,
                       SppCallbackData, "Button2 clicked.",
                       SppWidth, -120,
                       NULL);
    spCreatePushButton(container, "Button3",
                       SppCallbackFunc, spDisplayMessageCB,
                       SppCallbackData, "Button3 clicked.",
                       NULL);
    
    /* create container */
    container = spCreateBox(frame, "Container 2", 0,
                            /*SppOrientation, SP_HORIZONTAL,*/
                            SppOrientation, SP_VERTICAL,
                            SppBorderOn, SP_TRUE,
                            NULL);

    /* create push button */
    spCreatePushButton(container, "Width +10",
                       SppCallbackFunc, sizeCB,
                       SppCallbackData, 10,
                       NULL);
    spCreatePushButton(container, "Width -10",
                       SppCallbackFunc, sizeCB,
                       SppCallbackData, -10,
                       NULL);
    spCreatePushButton(container, "Quit",
                       SppCallbackFunc, spQuitCB,
                       NULL);

    /* popup window */
    spPopupWindow(frame);
    
    /* main loop */
    return spMainLoop(toplevel);
}
