#include <stdio.h>
#include <sp/spBaseLib.h>
#include <sp/spComponentLib.h>
#include <sp/spComponentMain.h>

#include <sp/spDial.h>

static void dialCB(spComponent component, void *data)
{
    int value;

    if (spGetDialValue(component, &value) == SP_TRUE) {
        spDebug(1, "dialCB", "value = %d\n", value);
    }
    
    return;
}

int spMain(int argc, char *argv[])
{
    spTopLevel toplevel;
    spComponent frame;

    /*spSetDebugLevel(100);*/
    
    /* initialize toolkit */
    toplevel = spInitialize(&argc, &argv, NULL);
    
    /* create main window */
    frame = spCreateMainFrame("Dial", NULL);

    /* create dial */
    spCreateDial(frame, "Dial",
                 SppCallbackFunc, dialCB,
                 SppShowScale, SP_TRUE,
                 NULL);

    /* create push button */
    spCreatePushButton(frame, "Quit",
                       SppCallbackFunc, spQuitCB,
                       NULL);

    /* popup window */
    spPopupWindow(frame);
    
    /* main loop */
    return spMainLoop(toplevel);
}
