#include <stdio.h>
#include <sp/spBaseLib.h>
#include <sp/spComponentLib.h>
#include <sp/spComponentMain.h>

#include <sp/spDial.h>

spComponent text1 = NULL;
spComponent text2 = NULL;

static void dialCB(spComponent component, int id)
{
    int value;
    char buf[SP_MAX_LINE];

    if (spGetDialValue(component, &value) == SP_TRUE) {
        spDebug(10, "dialCB", "%d: value = %d\n", id, value);

        sprintf(buf, "%d", value);
        if (id == 1) {
            spSetTextString(text1, buf);
        } else {
            spSetTextString(text2, buf);
        }
    }
    
    return;
}

static void textCB(spComponent component, void *data)
{
    char *string;
    int value;

    if ((string = xspGetTextString(component)) != NULL) {
        spComponent dial = (spComponent)data;
        
        value = 0;
        sscanf(string, "%d\n", &value);

        spSetDialValue(dial, value);
        
        xspFree(string);
    }
    
    return;
}

int spMain(int argc, char *argv[])
{
    spTopLevel toplevel;
    spComponent frame, dial1, dial2;

    /*spSetDebugLevel(30);*/
    
    /* initialize toolkit */
    toplevel = spInitialize(&argc, &argv, NULL);
    
    /* create main window */
    frame = spCreateMainFrame("Dial", NULL);

    /* create dial */
    dial1 = spCreateDial(frame, "Dial",
                         SppCallbackFunc, dialCB,
                         SppCallbackData, 1,
                         SppShowScale, SP_TRUE,
                         NULL);
    text1 = spCreateTextField(frame, "text1",
                              SppCallbackFunc, textCB,
                              SppCallbackData, dial1,
                              SppDescription, "Dial1 value.",
                              NULL);
    
    dial2 = spCreateDial(frame, "Dial2",
                         SppCallbackFunc, dialCB,
                         SppCallbackData, 2,
                         SppShowScale, SP_TRUE,
                         NULL);
    text2 = spCreateTextField(frame, "text2",
                              SppCallbackFunc, textCB,
                              SppCallbackData, dial2,
                              SppDescription, "Dial2 value.",
                              NULL);

    /* create push button */
    spCreatePushButton(frame, "Quit",
                       SppCallbackFunc, spQuitCB,
                       NULL);

    /* popup window */
    spPopupWindow(frame);
    
    /* main loop */
    return spMainLoop(toplevel);
}
