#include <stdio.h>
#include <sp/spBaseLib.h>
#include <sp/spComponentLib.h>
#include <sp/spComponentMain.h>

static spComponent dialog = NULL;
static spComponent text1 = NULL;
static spComponent text2 = NULL;

static void popdownDialogBoxCB(spComponent component, void *data)
{
    spCallbackReason reason;

    reason = spGetCallbackReason(component);
    spDebug(1, "popdownDialogBoxCB", "reason = %d\n", reason);
    
    if (reason != SP_CR_APPLY) {
        spPopdownWindow(component);
    }
    
    if (reason == SP_CR_CANCEL) {
        spDisplayMessage(component, NULL, "reason is SP_CR_CANCEL\n");
    } else if (reason == SP_CR_APPLY) {
        spDisplayMessage(component, NULL, "reason is SP_CR_APPLY\n");
    } else if (reason == SP_CR_OK) {
        spDisplayMessage(component, NULL, "reason is SP_CR_OK\n");
    } else {
        spDisplayMessage(component, NULL, "unknown reason: %d\n", reason);
    }

    return;
}

static void updateTextCB(spComponent component, void *data)
{
    char *message = (char *)data;

#if 1
    spSetTextString(text1, message);
#else
    spDisplayMessage(component, NULL, message);
#endif

    return;
}

static void dialogBoxCB(spComponent component, void *data)
{
    spDebug(10, "dialogBoxCB", "in\n");

    if (spIsCreated(dialog) == SP_FALSE) {
        spDebug(10, "dialogBoxCB", "create new dialog box\n");
        dialog = spCreateDialogBox("Dialog Box",
                                   SppCallbackFunc, popdownDialogBoxCB,
                                   SppCloseStyle, SP_UNMAP_CLOSE,
                                   SppDialogBoxButtonType, SP_DB_OK_CANCEL_APPLY,
                                   NULL);
        
        text1 = spCreateTextField(dialog, "textField",
                                  /*SppWidth, 0,*/
                                  SppInitialWidth, 300,
                                  NULL);
        spCreateLabel(dialog, "Label",
                      NULL);
        spCreatePushButton(dialog, "Button1",
                           SppCallbackFunc, updateTextCB,
                           SppCallbackData, "Button1 clicked.",
                           NULL);
        spCreatePushButton(dialog, "Button2",
                           SppCallbackFunc, updateTextCB,
                           SppCallbackData, "Button2 clicked.",
                           NULL);
        text2 = spCreateTextArea(dialog, "textArea",
                                 SppInitialWidth, 300,
                                 NULL);
    }
    spPopupWindow(dialog);
    
    spDebug(10, "dialogBoxCB", "popup done\n");
    
    return;
}

int spMain(int argc, char *argv[])
{
    spTopLevel toplevel;
    spComponent frame;

    dialog = NULL;
    
    /*spSetDebugLevel(100);*/
    
    /* initialize toolkit */
    toplevel = spInitialize(&argc, &argv, NULL);
    
    /* create main window */
    frame = spCreateMainFrame("Dialog Box", NULL);

    /* create push button */
    spCreatePushButton(frame, "Create Dialog Box",
                       SppCallbackFunc, dialogBoxCB,
                       SppInitialWidth, 200,
                       NULL);
    spCreatePushButton(frame, "Quit",
                       SppCallbackFunc, spQuitCB,
                       SppInitialWidth, 200,
                       NULL);

    /* popup window */
    spPopupWindow(frame);
    
    /* main loop */
    return spMainLoop(toplevel);
}
