#include <stdio.h>
#include <sp/spBaseLib.h>
#include <sp/spComponentLib.h>
#include <sp/spComponentMain.h>

spComponent list = NULL;

static void dropCB(spComponent component, void *data, int argc, char **argv)
{
    int i;

    spDebug(1, "drogCB", "argc = %d\n", argc);
    for (i = 0; i < argc; i++) {
        spDebug(1, "drogCB", "argv[%d] = %s\n", i, argv[i]);
        spAddListItem(list, argv[i]);
    }
    
    return;
}

int spMain(int argc, char *argv[])
{
    spTopLevel toplevel;
    spComponent frame;

    /*spSetDebugLevel(100);*/

    /* initialize toolkit */
    toplevel = spInitialize(&argc, &argv,
                            SppUniqueApplicationId, "spDragDropTest",
                            SppApplicationDomainId, "spDragDropTest.spComponent.spLibs.org",
                            SppThreadSafe, SP_TRUE,
                            NULL);
    
    /* create main window */
    frame = spCreateMainFrame("Drag & Drop", NULL);

    /* create list */
    list = spCreateList(frame, "list",
                        SppInitialWidth, 200,
                        SppHeight, -spGetButtonDefaultHeight(SP_TRUE),
                        NULL);

    /* create push button */
    spCreatePushButton(frame, "Quit",
                       SppCallbackFunc, spQuitCB,
                       SppInitialWidth, 200,
                       NULL);
    
    if (spAddDropCallback(frame, dropCB, NULL) == SP_FALSE) {
        spDisplayWarning(frame, NULL, "Sorry. The drag & drop is not supported in this environment.");
    }

    /* popup window */
    spPopupWindow(frame);
    
    /* main loop */
    return spMainLoop(toplevel);
}
