#include <stdio.h>
#include <sp/spBaseLib.h>
#include <sp/spComponentLib.h>
#include <sp/spComponentMain.h>

static void closeCB(spComponent component, int count)
{
    if (spGetCallbackReason(component) == SP_CR_CLOSE) {
        spDebug(1, "closeCB", "close: %d\n", count);
    } else {
        spDebug(1, "closeCB", "destroy: %d\n", count);
    }
    
    return;
}

static void checkCloseButtonCB(spComponent component, spComponent window)
{
    spBool set;
    
    if (spGetToggleState(component, &set) == SP_TRUE) {
        if (set == SP_FALSE) {
            spSetParams(window,
                        SppCloseStyle, SP_NO_CLOSE,
                        NULL);
        } else {
            spSetParams(window,
                        SppCloseStyle, SP_CALLBACK_CLOSE,
                        NULL);
        }
    }

    return;
}

static void checkTopMostCB(spComponent component, spComponent window)
{
    spBool set;
    
    if (spGetToggleState(component, &set) == SP_TRUE) {
        if (set == SP_FALSE) {
            spSetParams(window,
                        SppTopMost, SP_FALSE,
                        NULL);
        } else {
            spSetParams(window,
                        SppTopMost, SP_TRUE,
                        NULL);
        }
    }

    return;
}

static void lowerFrameCB(spComponent component, spComponent window)
{
    spLowerWindow(window);
    return;
}

int spMain(int argc, char *argv[])
{
    spTopLevel toplevel;
    spComponent frame1, frame2;

    /*spSetDebugLevel(50);*/
    
    /* initialize toolkit */
    toplevel = spInitialize(&argc, &argv, NULL);
    
    /* create window */
    frame1 = spCreateFrame("Frame 1",
                           SppCloseStyle, SP_CALLBACK_CLOSE,
                           SppCallbackFunc, closeCB,
                           SppCallbackData, 1,
                           NULL);
    spAddCallback(frame1, SP_CLOSE_CALLBACK,
                  (spCallbackFunc)closeCB, (void *)2);
    spAddCallback(frame1, SP_DESTROY_CALLBACK,
                  (spCallbackFunc)closeCB, (void *)3);

    spCreateCheckBox(frame1, "Enable Close Button",
                     SppCallbackFunc, checkCloseButtonCB,
                     SppCallbackData, frame1,
                     SppSet, SP_TRUE,
                     NULL);
    spCreateCheckBox(frame1, "Enable Topmost",
                     SppCallbackFunc, checkTopMostCB,
                     SppCallbackData, frame1,
                     SppSet, SP_FALSE,
                     NULL);
    
    /* create push buttons */
    spCreatePushButton(frame1, "Close Frame 1",
                       SppCallbackFunc, spCloseWindowCB,
                       SppInitialWidth, 200,
                       NULL);
    spCreatePushButton(frame1, "Lower Frame 1",
                       SppCallbackFunc, lowerFrameCB,
                       SppCallbackData, frame1,
                       NULL);
    spCreatePushButton(frame1, "Quit",
                       SppCallbackFunc, spQuitCB,
                       NULL);

    /* popup window */
    spPopupWindow(frame1);
    
    /* create window */
    frame2 = spCreateFrame("Frame 2",
                           SppCloseStyle, SP_CALLBACK_CLOSE,
                           SppCallbackFunc, closeCB,
                           SppCallbackData, 1,
                           NULL);
    spAddCallback(frame2, SP_CLOSE_CALLBACK,
                  (spCallbackFunc)closeCB, (void *)2);
    spAddCallback(frame2, SP_DESTROY_CALLBACK,
                  (spCallbackFunc)closeCB, (void *)3);

    spCreateCheckBox(frame2, "Enable Close Button",
                     SppCallbackFunc, checkCloseButtonCB,
                     SppCallbackData, frame2,
                     SppSet, SP_TRUE,
                     NULL);
    
    /* create push button */
    spCreatePushButton(frame2, "Close Frame 2",
                       SppCallbackFunc, spCloseWindowCB,
                       SppInitialWidth, 200, 
                       NULL);
    spCreatePushButton(frame2, "Lower Frame 2",
                       SppCallbackFunc, lowerFrameCB,
                       SppCallbackData, frame2,
                       NULL);
    spCreatePushButton(frame2, "Quit",
                       SppCallbackFunc, spQuitCB,
                       NULL);

    /* popup window */
    spPopupWindow(frame2);
    
    /* main loop */
    return spMainLoop(toplevel);
}
