#include <stdio.h>
#include <sp/spBaseLib.h>
#include <sp/spComponentLib.h>
#include <sp/spComponentMain.h>

#define TEST_LIST 1

int spMain(int argc, char *argv[])
{
    spTopLevel toplevel;
    spComponent frame;

    /* initialize toolkit */
    toplevel = spInitialize(&argc, &argv, NULL);

    /* create main window */
    frame = spCreateMainFrame("Fullscreen",
                              SppWindowType, SP_FULLSCREEN_WINDOW,
                              NULL);

#if defined(TEST_LIST)
    {
        int i;
        char buf[SP_MAX_LINE];
        spComponent list;
        
        list = spCreateList(frame, "list",
                            SppInitialWidth, 200,
                            SppCallbackFunc, spQuitCB,
                            NULL);
        
        for (i = 1; i <= 100; i++) {
            sprintf(buf, "List Item %d", i);
            spAddListItem(list, buf);
        }
    }
#else
    /* create push button */
    spCreatePushButton(frame, "Hello World",
                       SppCallbackFunc, spQuitCB,
                       SppCallbackData, SP_TRUE,
                       SppDefaultButton, SP_TRUE,
                       NULL);
#endif

    /* popup window */
    spPopupWindow(frame);
    
    /* main loop */
    return spMainLoop(toplevel);
}
