#include <stdio.h>
#include <sp/spBaseLib.h>
#include <sp/spComponentLib.h>
#include <sp/spComponentMain.h>

void buttonCB(spComponent component, char *message)
{
    spDisplayMessage(component, "Message", message);
    
    return;
}

int spMain(int argc, char *argv[])
{
    spTopLevel toplevel;
    spComponent frame;

    /* initialize toolkit */
    toplevel = spInitialize(&argc, &argv, NULL);

    /* create main window */
    frame = spCreateMainFrame("Hello World", NULL);

    /* create push buttons */
    spCreatePushButton(frame, "Button1",
                       SppTitle, "Hello World 1",
                       SppDefaultButton, SP_TRUE,
                       SppCallbackFunc, buttonCB,
                       SppCallbackData, "Hello 1",
                       NULL);
    spCreatePushButton(frame, "Button2",
                       SppTitle, "Hello World 2",
                       SppCallbackFunc, buttonCB,
                       SppCallbackData, "Hello 2",
                       NULL);

    /* popup window */
    spPopupWindow(frame);
    
    /* main loop */
    return spMainLoop(toplevel);
}
