#include <stdio.h>
#include <sp/spBaseLib.h>
#include <sp/spComponentLib.h>
#include <sp/spComponentMain.h>

static spComponent text;

static void listCB(spComponent component, void *data)
{
    char *string;
    spCallbackReason reason;

    reason = spGetCallbackReason(component);
    spDebug(50, "listCB", "reason = %d\n", reason);

    if ((string = xspGetSelectedListItem(component)) != NULL) {
        spDebug(10, "listCB", "string = %s\n", string);
        spSetTextString(text, string);

        if (reason == SP_CR_ACTIVATE) {
            spDisplayMessage(component, NULL, "Activated: %s", string);
            spDebug(10, "listCB", "activated\n");
        } else if (reason == SP_CR_VALUE_CHANGED) {
            /*spDisplayMessage(component, NULL, "Value Changed: %s", string);*/
            spDebug(10, "listCB", "value changed\n");
        }
        
        xspFree(string);
    }
    
    return;
}

static void addListItemCB(spComponent component, spComponent list)
{
    char *string;

    if ((string = xspGetTextString(text)) != NULL) {
        spDebug(10, "addListItemCB", "string = %s\n", string);
        if (!spStrNone(string)) {
            spAddListItem(list, string);
        }
        xspFree(string);
    }
    
    return;
}

static void deleteListItemCB(spComponent component, spComponent list)
{
    char *string;

    if ((string = xspGetTextString(text)) != NULL) {
        spDebug(10, "deleteListItemCB", "string = %s\n", string);
        if (!spStrNone(string)) {
            spDeleteListItem(list, string);
        }
        xspFree(string);
    }
    
    return;
}

static void getListItemCB(spComponent component, spComponent list)
{
    char *string;

    if ((string = xspGetSelectedListItem(list)) != NULL) {
        spDebug(10, "getListItemCB", "string = %s\n", string);
        spSetTextString(text, string);
        xspFree(string);
    }
    
    return;
}

int spMain(int argc, char *argv[])
{
    spTopLevel toplevel;
    spComponent frame;
    spComponent list;
    spComponent box;
    char *list_strings[] =
    {
        "1",
        "2",
        "3",
        "4",
        "5",
        NULL,
    };

    /*spSetDebugLevel(20);*/

    /* initialize toolkit */
    toplevel = spInitialize(&argc, &argv, NULL);
    
    /* create main window */
    frame = spCreateMainFrame("List", NULL);

    /* create list */
    list = spCreateList(frame, "list",
                        SppInitialWidth, 200,
                        SppHeight, -2 * spGetTextFieldDefaultHeight(SP_TRUE),
                        SppListStrings, list_strings,
                        SppCallbackFunc, listCB,
                        NULL);
    spDebug(50, "main", "spCreateList done\n");
    spAddListItem(list, "Item 1");
    spAddListItem(list, "Item 2");
    spAddListItem(list, "Item 3");
    spAddListItem(list, "Item 4");
    spAddListItem(list, "Item 5");
    spAddListItem(list, "Item 6");
    spAddListItem(list, "Item 7");
    spAddListItem(list, "Item 8");
    spAddListItem(list, "Item 9");
    spAddListItem(list, "Item 10");

    /* create text field */
    text = spCreateTextField(frame, "text", NULL);

    /* create box */
    box = spCreateBox(frame, "box", spGetTextFieldDefaultHeight(SP_TRUE),
                      SppOrientation, SP_HORIZONTAL,
                      NULL);
    
    /* create push button */
    spCreatePushButton(box, "Add",
                       SppCallbackFunc, addListItemCB,
                       SppCallbackData, list,
                       SppPercentageWidth, 33,
                       NULL);
    spCreatePushButton(box, "Delete",
                       SppCallbackFunc, deleteListItemCB,
                       SppCallbackData, list,
                       SppPercentageWidth, 33,
                       NULL);
    spCreatePushButton(box, "Get",
                       SppCallbackFunc, getListItemCB,
                       SppCallbackData, list,
                       SppPercentageWidth, 33,
                       NULL);

    /* popup window */
    spPopupWindow(frame);
    
    /* main loop */
    return spMainLoop(toplevel);
}
