#include <stdio.h>
#include <sp/spBaseLib.h>
#include <sp/spComponentLib.h>
#include <sp/spComponentMain.h>

//#define DIRECT_COPY_TEST

static spGraphics graphics = NULL;
static spDIBitmap dibitmap = NULL;

#if !defined(DIRECT_COPY_TEST)
static spComponent image = NULL;
#endif

static void canvasCB(spComponent component, void *data)
{
    int w, h;
    spBool status;
    spComponent dest;

#if defined(DIRECT_COPY_TEST)
    dest = component;
#else
    dest = image;
#endif

    w = dibitmap->info.width;
    h = dibitmap->info.height;
    spDebug(10, "canvasCB", "width = %d, height = %d\n", w, h);
    
    spLockDIBitmap(dibitmap);
    if ((status = spCopyDIBitmapToImage(dibitmap, dest, 0, 0,
                                        dibitmap->info.width, dibitmap->info.height, 0, 0)) == SP_FALSE) {
        spDisplayError(component, NULL, "Cannot execute spCopyDIBitmapToImage");
    }
    spUnlockDIBitmap(dibitmap);
    
#if !defined(DIRECT_COPY_TEST)
    spCopyImage(image, component, 0, 0, w, h, 0, 0);
#endif

    spDrawLine(component, graphics, 0, 0, w, h);
    spDrawLine(component, graphics, w, 0, 0, h);
    
    spRefreshCanvas(component);
    
    return;
}

int spMain(int argc, char *argv[])
{
    spTopLevel toplevel;
    spComponent frame;
    spComponent menu, menu_bar;
    spComponent canvas;
    char *filename;

    /* initialize toolkit */
    toplevel = spInitialize(&argc, &argv, NULL);
    
    /* create main window */
    frame = spCreateMainFrame("Load DIBitmap",
                              SppResizable, SP_FALSE,
                              NULL);

    /* create menu bar */
    menu_bar = spCreateMenuBar(frame, "menuBar", NULL);
    
    /* create menu */
    menu = spCreatePulldownMenu(menu_bar, "fileMenu",
                                SppTitle, "File",
                                NULL);
    
    /* add menu item */
    spAddMenuItem(menu, SP_QUIT_MENU_ITEM_NAME,
                  SppCallbackFunc, spQuitCB,
                  SppTitle, "Quit",
                  SppShortcut, "A-q",
                  NULL);

    if (argc >= 2) {
        filename = argv[1];
    } else {
#if !(defined(ANDROID) || defined(IPHONE))
        filename = xspGetOpenFileName(frame, NULL,
                                      SppPathMustExist, SP_TRUE,
                                      SppFileMustExist, SP_TRUE,
                                      NULL);

        if (filename == NULL) {
            spDisplayError(frame, NULL, "A file must be specified.\n");
            spQuit(0);
        }
#else
        filename = "tool_bar.png";
#endif
    }
    spDebug(10, "spMain", "filename = %s\n", filename);

    /* load bitmap file */
    if ((dibitmap = spCreateDIBitmapFromFile(filename)) != NULL) {
        fprintf(stderr, "bitmap: width = %ld, height = %ld\n", dibitmap->info.width, dibitmap->info.height);

#if !defined(DIRECT_COPY_TEST)
        image = spCreateImage(frame, "image", dibitmap->info.width, dibitmap->info.height, NULL);
#endif

        /* create canvas */
        canvas = spCreateCanvas(frame, "canvas", dibitmap->info.width, dibitmap->info.height,
                                SppDisableInitialScaling, SP_TRUE,
                                SppBorderOn, SP_FALSE,
                                SppDrawBackground, SP_TRUE,
                                SppCallbackFunc, canvasCB,
                                NULL);

        graphics = spCreateGraphics("graphics1",
                                    SppLineType, SP_LINE_DASH_DOT,
                                    SppLineWidth, 1,
                                    SppForeground, "red",
                                    NULL);
    } else {
        spDebug(10, "spMain", "spCreateDIBitmapFromFile failed\n");
        spDisplayError(frame, NULL, "Cannot open bitmap file: %s", filename);
        spQuit(0);
    }
    
    /* popup window */
    spPopupWindow(frame);
    
    /* main loop */
    return spMainLoop(toplevel);
}
