#include <stdio.h>
#include <sp/spBaseLib.h>
#include <sp/spComponentLib.h>
#include <sp/spComponentMain.h>

static spGraphics graphics = NULL;

static void canvasCB(spComponent component, spComponent image)
{
    int w, h;

    spGetSize(image, &w, &h);
    spDebug(10, "canvasCB", "width = %d, height = %d\n", w, h);
    
    spCopyImage(image, component, 0, 0, w, h, 0, 0);

    spDrawLine(component, graphics, 0, 0, w, h);
    spDrawLine(component, graphics, w, 0, 0, h);
    
    spRefreshCanvas(component);
    
    spDebug(10, "canvasCB", "done\n");
    
    return;
}

int spMain(int argc, char *argv[])
{
    spTopLevel toplevel;
    spComponent frame;
    spComponent menu, menu_bar;
    spComponent canvas, image;
    char *filename;
    int width, height;

    /*spSetDebugLevel(100);*/

    /* initialize toolkit */
    toplevel = spInitialize(&argc, &argv, NULL);
    
    /* create main window */
    frame = spCreateMainFrame("Load Image",
                              SppResizable, SP_FALSE,
                              NULL);

    /* create menu bar */
    menu_bar = spCreateMenuBar(frame, "menuBar", NULL);
    
    /* create menu */
    menu = spCreatePulldownMenu(menu_bar, "fileMenu",
                                SppTitle, "File",
                                NULL);
    
    /* add menu item */
    spAddMenuItem(menu, SP_QUIT_MENU_ITEM_NAME,
                  SppCallbackFunc, spQuitCB,
                  SppTitle, "Quit",
                  SppShortcut, "A-q",
                  NULL);

    if (argc >= 2) {
        filename = argv[1];
    } else {
#if !(defined(ANDROID) || defined(IPHONE))
        filename = xspGetOpenFileName(frame, NULL,
                                      SppPathMustExist, SP_TRUE,
                                      SppFileMustExist, SP_TRUE,
                                      NULL);

        if (filename == NULL) {
            spDisplayError(frame, NULL, "A file must be specified.\n");
            spQuit(0);
        }
#else
        filename = "tool_bar";
#endif
    }

    /* load image file */
    if ((image = spCreateImageFromFile(frame, filename, NULL)) != NULL) {
        spGetSize(image, &width, &height);
        fprintf(stderr, "image: width = %d, height = %d\n", width, height);

        /* create canvas */
        canvas = spCreateCanvas(frame, "canvas", width, height,
                                SppDisableInitialScaling, SP_TRUE,
                                SppBorderOn, SP_FALSE,
                                SppDrawBackground, SP_TRUE/*SP_FALSE*/,
                                SppCallbackFunc, canvasCB,
                                SppCallbackData, image,
                                NULL);

        graphics = spCreateGraphics("graphics1",
                                    SppLineType, SP_LINE_DASH_DOT,
                                    SppLineWidth, 1,
                                    SppForeground, "red",
                                    NULL);
    } else {
        spDisplayError(frame, NULL, "Cannot open image file: %s", filename);
        spQuit(0);
    }
    
    /* popup window */
    spPopupWindow(frame);
    
    /* main loop */
    return spMainLoop(toplevel);
}
