#include <stdio.h>
#include <sp/spBaseLib.h>
#include <sp/spComponentLib.h>
#include <sp/spComponentMain.h>

static spBool editable = SP_TRUE;
static spComponent text_field1 = NULL;
static spComponent text_field2 = NULL;
static spComponent text_field3 = NULL;

static void textCB(spComponent component, void *data)
{
    char *string;

    if ((string = xspGetTextString(component)) != NULL) {
        printf("%s\n", string);
        xspFree(string);
    }
    
    return;
}

static void checkCB(spComponent component, void *data)
{
    if (spGetToggleState(component, &editable) == SP_TRUE) {
        printf("check: %d\n", editable);
        spSetParams(text_field1, SppEditable, editable, NULL);
        spSetParams(text_field2, SppEditable, editable, NULL);
        spSetParams(text_field3, SppEditable, editable, NULL);
    }

    return;
}

int spMain(int argc, char *argv[])
{
    spTopLevel toplevel;
    spComponent frame;

    /*spSetDebugLevel(50);*/
    
    /* initialize toolkit */
    toplevel = spInitialize(&argc, &argv, NULL);
    
    /* create main window */
    frame = spCreateMainFrame("Multi Text", NULL);

    /* create check box */
    spCreateCheckBox(frame, "Editable",
                     SppSet, editable,
                     SppCallbackFunc, checkCB,
                     NULL);

    /* create text field */
    text_field1 = spCreateTextField(frame, "text1",
                                    SppCallbackFunc, textCB,
                                    SppTextString, "This is text 1.",
                                    SppDescription, "This is text field 1.",
                                    NULL);
    text_field2 = spCreateTextField(frame, "text2",
                                    SppCallbackFunc, textCB,
                                    SppTextString, "This is text 2.",
                                    SppDescription, "This is text field 2.",
                                    NULL);
    text_field3 = spCreateTextField(frame, "text3",
                                    SppCallbackFunc, textCB,
                                    SppTextString, "This is text 3.",
                                    SppDescription, "This is text field 3.",
                                    NULL);

    /* popup window */
    spPopupWindow(frame);
    
    /* main loop */
    return spMainLoop(toplevel);
}
