#include <stdio.h>
#include <sp/spBaseLib.h>
#include <sp/spComponentLib.h>
#include <sp/spComponentMain.h>

static spComponent dialog = NULL;
static spComponent text_field = NULL;

static int selected_number = 0;
static char selected_string[SP_MAX_LINE] = "";
static char command_only_string[SP_MAX_LINE] = "";

static spOptions options;
static spOption option[] = {
    {"-n", "-num", "selected number",
         "number|Selected Number|140|0||0",
         SP_TYPE_EDITABLE|SP_TYPE_COMBO|SP_TYPE_INT, &selected_number,
         "1|2|3|@4"},
    {"-s", "-str", "selected string",
         "string|Selected String|140|0||0",
         SP_TYPE_EDITABLE|SP_TYPE_COMBO|SP_TYPE_STRING_A, selected_string,
         "String 1|String 2|@String 3|String 4"},
    {"-C", "-conly", "command-line only option",
         "string", SP_TYPE_NO_GUI | SP_TYPE_STRING_A, command_only_string,
         "String 1"},
};


void popdownDialogCB(spComponent component, void *data)
{
    spCallbackReason reason;
    char buf[SP_MAX_LINE];
    
    spDebug(10, "popdownDialogCB", "in\n");
    
    reason = spGetCallbackReason(component);

    if (reason == SP_CR_OK || reason == SP_CR_CANCEL) {
        spPopdownWindow(component);
    }

    if (reason == SP_CR_OK || reason == SP_CR_APPLY) {
        spGetOptionDialogData(component);
        sprintf(buf, "Number = %d, String = %s.", selected_number, selected_string);
        spSetTextString(text_field, buf);
        
        spDebug(10, "popdownDialogCB", "number = %d, buf = %s, len = %d\n",
                selected_number, buf, strlen(buf));
    }
    
    return;
}

void popupDialogCB(spComponent component, void *data)
{
    spDebug(10, "popupDialogCB", "in\n");

    if (spIsCreated(dialog) == SP_FALSE) {
        options = spAllocOptions(spArraySize(option), option);
        
        spDebug(10, "popupDialogCB", "create new dialog\n");
        dialog = spCreateOptionDialog("Option Dialog",
                                      options,
                                      SppCallbackFunc, popdownDialogCB,
                                      SppDialogBoxButtonType, SP_DB_OK_CANCEL_APPLY,
                                      SppCloseStyle, SP_UNMAP_CLOSE,
                                      NULL);
    }
    spPopupWindow(dialog);
    
    spDebug(10, "popupDialogCB", "popup done\n");
    
    return;
}

int spMain(int argc, char *argv[])
{
    spTopLevel toplevel;
    spComponent frame;

    dialog = NULL;
    /*spSetDebugLevel(100);*/
    
    /* initialize toolkit */
    toplevel = spInitialize(&argc, &argv, NULL);
    
    /* create main window */
    frame = spCreateMainFrame("Option Dialog", NULL);

    /* create push button */
    spCreatePushButton(frame, "Create Option Dialog",
                       SppCallbackFunc, popupDialogCB,
                       SppInitialWidth, 250,
                       NULL);

    /* create push button */
    spCreatePushButton(frame, "Quit",
                       SppCallbackFunc, spQuitCB,
                       NULL);

    /* create text field */
    text_field = spCreateTextField(frame, "text",
                                   NULL);

    /* popup window */
    spPopupWindow(frame);
    
    /* main loop */
    return spMainLoop(toplevel);
}
