#include <stdio.h>
#include <sp/spBaseLib.h>
#include <sp/spComponentLib.h>
#include <sp/spComponentMain.h>

static spComponent dialog = NULL;

static int selected_number = 0;
static char selected_string[SP_MAX_LINE] = "";
static long selected_long_number = 0;
static double selected_double_number = 0.0;
static int select_only_number = 0;
static char command_only_string[SP_MAX_LINE] = "";

static spOptions options1;
static spOptions options2;
static spOption option[] = {
    {"-n", "-num", "selected number",
         "number|Selected Number|120|0||0",
         SP_TYPE_EDITABLE|SP_TYPE_COMBO|SP_TYPE_INT, &selected_number,
         "1|2|3|@4"},
    {"-s", "-str", "selected string",
         "string|Selected String|120|0||0",
         SP_TYPE_EDITABLE|SP_TYPE_COMBO|SP_TYPE_STRING_A, selected_string,
         "String 1|String 2|@String 3|String 4"},
    {"-l", "-long", "selected long number",
         "number|Selected Long Number|160|0||0",
         SP_TYPE_EDITABLE|SP_TYPE_COMBO|SP_TYPE_LONG, &selected_long_number,
         "5|@6|7|8"},
    {"-d", "-double", "selected double number",
         "number|Selected Double Number|160|0||0",
         SP_TYPE_EDITABLE|SP_TYPE_COMBO|SP_TYPE_DOUBLE, &selected_double_number,
         "@0.1|0.2|0.3|0.4"},
    {"-so", "-selonly", "select only number",
         "number|Select Only Number|160|0||0",
         SP_TYPE_COMBO|SP_TYPE_INT, &select_only_number,
         "100|200|@300|400"},
    {"-C", "-conly", "command-line only option",
         "string", SP_TYPE_NO_GUI | SP_TYPE_STRING_A, command_only_string,
         "String 1"},
};

void displayCurrentDataCB(spComponent component, void *data)
{
    const char *name;
    char buf[SP_MAX_MESSAGE];
    spComponent parent = (spComponent)data;
    
    spDebug(10, "displayCurrentDataCB", "in\n");
    
    spGetOptionParamFieldsData(parent);
    
    name = spGetName(parent);

    if (streq(name, "Options 1")) {
        sprintf(buf, "Number = %d, String = %s", selected_number, selected_string);
    } else {
        sprintf(buf, "Long = %ld, Double = %f, Select Only Number = %d",
                selected_long_number, selected_double_number, select_only_number);
    }

    spDisplayMessage(parent, NULL, buf);
    
    return;
}

int spMain(int argc, char *argv[])
{
    spTopLevel toplevel;
    spComponent frame, button1, button2;
    spComponent tab_box, tab_item1, tab_item2;

    dialog = NULL;
    /*spSetDebugLevel(100);*/
    
    /* initialize toolkit */
    toplevel = spInitialize(&argc, &argv, NULL);
    
    /* create main window */
    frame = spCreateMainFrame("Option Fields", NULL);

    /* create push button */
    button1 = spCreatePushButton(frame, "Get Options1 Values",
                                 SppInitialWidth, 250,
                                 NULL);
    button2 = spCreatePushButton(frame, "Get Options2 Values",
                                 SppInitialWidth, 250,
                                 NULL);

    /* create push button */
    spCreatePushButton(frame, "Quit",
                       SppCallbackFunc, spQuitCB,
                       NULL);

    /* create tab box */
    tab_box= spCreateTabBox(frame, "tab", 220,
                            SppSpacingOn, SP_TRUE,
                            NULL);

    /* add tab item */
    tab_item1 = spAddTabItem(tab_box, "Options 1", -1,
                             NULL);
    options1 = spAllocOptions(2, &option[0]);
    spCreateOptionParamFields(tab_item1, options1);
    spAddCallback(button1, SP_ACTIVATE_CALLBACK, displayCurrentDataCB, tab_item1);

    tab_item2 = spAddTabItem(tab_box, "Options 2", -1,
                             NULL);
    options2 = spAllocOptions(3, &option[2]);
    spCreateOptionParamFields(tab_item2, options2);
    spAddCallback(button2, SP_ACTIVATE_CALLBACK, displayCurrentDataCB, tab_item2);
    
    /* popup window */
    spPopupWindow(frame);
    
    /* main loop */
    return spMainLoop(toplevel);
}
