#include <stdio.h>
#include <sp/spBaseLib.h>
#include <sp/spComponentLib.h>
#include <sp/spComponentMain.h>

static void helloCB(spComponent component, void *data)
{
    static int count = 0;

    spDebug(10, "helloCB", "count = %d\n", count);

    if (count >= 1) {
        if (spQuitPrompt(component) == SP_TRUE) {
            /* quit program */
            spQuit(0);
        } else {
            /* change label */
            spSetParams(component, SppTitle, "Hello World", NULL);
            count = 0;
        }
    } else {
        /* change label */
        spSetParams(component, SppTitle, "Goodbye World", NULL);
        count++;
    }
    
    return;
}

int spMain(int argc, char *argv[])
{
    spTopLevel toplevel;
    spComponent frame, label, button;
    spComponent menu;

    /*spSetDebugLevel(100);*/

    /* initialize toolkit */
    toplevel = spInitialize(&argc, &argv, NULL);
    
    /* create main window */
    frame = spCreateMainFrame("Popup Menu", NULL);
    
    /* create label */
    label = spCreateLabel(frame, "Please click right button.",
                          SppAlignment, SP_ALIGNMENT_CENTER,
                          SppInitialWidth, 200,
                          NULL);
    
    /* create popup menu */
    menu = spCreatePopupMenu(label, "Menu",
                             SppPopupButton, SP_RBUTTON,
                             NULL);
    
    /* add menu item */
    spAddMenuItem(menu, "Hello World",
                  SppCallbackFunc, helloCB,
                  SppShortcut, "A-d",
                  NULL);

    /* create push button */
    button = spCreatePushButton(frame, "Quit",
                                SppCallbackFunc, spQuitCB,
                                SppDefaultButton, SP_TRUE,
                                NULL);
    
    /* popup window */
    spPopupWindow(frame);
    
    /* main loop */
    return spMainLoop(toplevel);
}
