#include <stdio.h>
#include <sp/spBaseLib.h>
#include <sp/spComponentLib.h>
#include <sp/spComponentMain.h>

static void buttonCB(spComponent component, void *data);

static void createWindow(spBool modal_flag)
{
    static char modeless_title[] = "Modeless Window";
    static char modal_title[] = "Modal Window";
    char *title;
    spPopupStyle popup_style;
    spComponent frame;

    if (modal_flag == SP_TRUE) {
        title = modal_title;
        popup_style = SP_MODAL_POPUP;
    } else {
        title = modeless_title;
        popup_style = SP_MODELESS_POPUP;
    }
    
    /* create main window */
    frame = spCreateFrame(title,
                          SppPopupStyle, popup_style,
                          SppCloseStyle, SP_DESTROY_CLOSE,
                          NULL);

    /* create push buttons */
    if (modal_flag == SP_FALSE) {
        /* because a modeless window cannot be created
           when a modal window exists */
        spCreatePushButton(frame, "Popup Modeless Window",
                           SppCallbackFunc, buttonCB,
                           SppCallbackData, SP_FALSE,
                           SppInitialWidth, 200,
                           NULL);
    }
    spCreatePushButton(frame, "Popup Modal Window",
                       SppCallbackFunc, buttonCB,
                       SppCallbackData, SP_TRUE,
                       SppInitialWidth, 200,
                       NULL);
    spCreatePushButton(frame, "Close",
                       SppCallbackFunc, spCloseWindowCB,
                       SppInitialWidth, 200,
                       NULL);
    spCreatePushButton(frame, "Quit",
                       SppCallbackFunc, spQuitCB,
                       SppInitialWidth, 200,
                       NULL);
    
    /* popup window */
    spPopupWindow(frame);
    
    return;
}

static void buttonCB(spComponent component, void *data)
{
    spBool modal_flag = (spBool)data;
    
    createWindow(modal_flag);
    return;
}

int spMain(int argc, char *argv[])
{
    spTopLevel toplevel;

    /*spSetDebugLevel(100);*/

    /* initialize toolkit */
    toplevel = spInitialize(&argc, &argv, NULL);

    createWindow(SP_FALSE);
    
    /* main loop */
    return spMainLoop(toplevel);
}
