#include <stdio.h>
#include <sp/spBaseLib.h>
#include <sp/spComponentLib.h>
#include <sp/spComponentMain.h>

static spComponent progress_bar = NULL;
static spComponent progress_bar2 = NULL;

static void incrementCB(spComponent component, void *data)
{
    int value;
    
    spIncrementProgressBar(progress_bar);
    spIncrementProgressBar(progress_bar2);

    if (spGetProgressBarValue(progress_bar, &value) == SP_TRUE
        && value >= 300) {
        if (spQuitPrompt(progress_bar) == SP_TRUE) {
            spQuit(0);
        } else {
            spSetProgressBarValue(progress_bar, 0);
            spSetProgressBarValue(progress_bar2, 0);
        }
    }
    
    return;
}

int spMain(int argc, char *argv[])
{
    spTopLevel toplevel;
    spComponent frame;

    /*spSetDebugLevel(10);*/
    
    /* initialize toolkit */
    toplevel = spInitialize(&argc, &argv, NULL);
    
    /* create main window */
    frame = spCreateMainFrame("Progress Bar", NULL);

    /* create progress bar */
    progress_bar = spCreateProgressBar(frame, "progressBar",
                                       SppMinimum, 0,
                                       SppMaximum, 300,
                                       SppDescription, "This is progress bar 1.",
                                       NULL);

    /* create progress bar */
    progress_bar2 = spCreateProgressBar(frame, "progressBar2",
                                        SppDescription, "This is progress bar 2.",
                                        NULL);

    /* create buttons */
    spCreatePushButton(frame, "Increment Progress Bar",
                       SppCallbackFunc, incrementCB,
                       NULL);
    spCreatePushButton(frame, "Quit",
                       SppCallbackFunc, spQuitCB,
                       NULL);

    /* popup window */
    spPopupWindow(frame);
    
    /* main loop */
    return spMainLoop(toplevel);
}
