#include <stdio.h>
#include <sp/spBaseLib.h>
#include <sp/spComponentLib.h>
#include <sp/spComponentMain.h>

static void radioButtonCB(spComponent component, int num)
{
    spBool set;
    
    if (spGetToggleState(component, &set)) {
        if (set == SP_TRUE) {
            spDisplayMessage(component, NULL, "Button %d: Checked", num);
        } else {
            spDisplayMessage(component, NULL, "Button %d: Unchecked", num);
        }
    }
    
    return;
}

int spMain(int argc, char *argv[])
{
    spTopLevel toplevel;
    spComponent frame;
    spComponent box1, box2;

    /* initialize toolkit */
    toplevel = spInitialize(&argc, &argv, NULL);
    
    /* create main window */
    frame = spCreateMainFrame("Radio Button", NULL);

    /* create box 1 */
    box1 = spCreateBox(frame, "Group 1", 3 * spGetButtonDefaultHeight(SP_TRUE),
                       SppOrientation, SP_VERTICAL,
                       SppBorderOn, SP_TRUE,
                       SppTitleOn, SP_TRUE,
                       NULL);
    
    /* create radio buttons */
    spCreateRadioButton(box1, "Button 1",
                        SppCallbackFunc, radioButtonCB,
                        SppCallbackData, 1,
                        SppSet, SP_TRUE,
                        NULL);
    spCreateRadioButton(box1, "Button 2",
                        SppCallbackFunc, radioButtonCB,
                        SppCallbackData, 2,
                        NULL);
    spCreateRadioButton(box1, "Button 3",
                        SppCallbackFunc, radioButtonCB,
                        SppCallbackData, 3,
                        SppRadioEnd, SP_TRUE,
                        NULL);

    /* create box 2 */
    box2 = spCreateBox(frame, "Group 2", 3 * spGetButtonDefaultHeight(SP_TRUE),
                       SppOrientation, SP_VERTICAL,
                       SppBorderOn, SP_TRUE,
                       SppTitleOn, SP_TRUE,
                       NULL);
    
    /* create radio buttons */
    spCreateRadioButton(box2, "Button 2-1",
                        SppCallbackFunc, radioButtonCB,
                        SppCallbackData, 4,
                        SppSet, SP_TRUE,
                        NULL);
    spCreateRadioButton(box2, "Button 2-2",
                        SppCallbackFunc, radioButtonCB,
                        SppCallbackData, 5,
                        NULL);
    spCreateRadioButton(box2, "Button 2-3",
                        SppCallbackFunc, radioButtonCB,
                        SppCallbackData, 6,
                        NULL);
    
    /* popup window */
    spPopupWindow(frame);
    
    /* main loop */
    return spMainLoop(toplevel);
}
