#include <stdio.h>
#include <sp/spBaseLib.h>
#include <sp/spComponentLib.h>
#include <sp/spComponentMain.h>

static spComponent button1 = NULL;
static spComponent button2 = NULL;
static spComponent check_box1 = NULL;
static spComponent check_box2 = NULL;
static spComponent text1 = NULL;
static spComponent text2 = NULL;
static spComponent container1 = NULL;
static spComponent container2 = NULL;
static spComponent scroll_bar = NULL;

static void scrollCB(spComponent component, void *data)
{
    int value;

    if (spGetSliderValue(component, &value)) {
        printf("value = %d\n", value);
    }
    
    return;
}

static spComponent createWindow(void)
{
    spComponent frame;
    spComponent menu_bar, menu;
    
    /* create window */
    frame = spCreateFrame("Frame", NULL);
    
    /* create menu bar */
    menu_bar = spCreateMenuBar(frame, "menuBar", NULL);
    
    /* create menu */
    menu = spCreatePulldownMenu(menu_bar, "File", NULL);
    
    /* add menu item */
    spAddMenuItem(menu, "Quit",
                  SppCallbackFunc, spQuitCB,
                  NULL);

    /* create push buttons */
    button1 = spCreatePushButton(frame, "Push Button 1",
                                  SppCallbackFunc, spDisplayMessageCB,
                                  SppCallbackData, "Push Button 1 clicked.",
                                  NULL);
    button2 = spCreatePushButton(frame, "Push Button 2",
                                  SppCallbackFunc, spDisplayMessageCB,
                                  SppCallbackData, "Push Button 2 clicked.",
                                  NULL);
    
    /* create scroll bar */
    scroll_bar = spCreateScrollBar(frame, "Scroll Bar",
                                   SppOrientation, SP_HORIZONTAL,
                                   SppMinimum, 0,
                                   SppMaximum, 100,
                                   SppIncrement, 10,
                                   SppPageIncrement, 20,
                                   SppPageSize, 50,
                                   SppValue, 0,
                                   SppCallbackFunc, scrollCB,
                                   NULL);
    
    /* create container */
    container1 = spCreateBox(frame, "Container 1", /*-300*/spGetButtonDefaultHeight(SP_TRUE) + 20,
                             SppOrientation, SP_HORIZONTAL,
                             SppBorderOn, SP_TRUE,
                             SppTitleOn, SP_TRUE,
                             NULL);
    
    /* create check boxes */
    check_box1 = spCreateCheckBox(container1, "Check Box 1",
                                SppCallbackFunc, spDisplayMessageCB,
                                SppCallbackData, "Check Box 1 clicked.",
                                NULL);
    check_box2 = spCreateCheckBox(container1, "Check Box 2",
                                SppCallbackFunc, spDisplayMessageCB,
                                SppCallbackData, "Check Box 2 clicked.",
                                NULL);
    
    /* create container */
    container2 = spCreateBox(frame, "Container 2", 0,
                             /*SppOrientation, SP_HORIZONTAL,*/
                             SppOrientation, SP_VERTICAL,
                             SppBorderOn, SP_TRUE,
                             NULL);

    /* create text fields */
    text1 = spCreateTextField(container2, "Text 1",
                              SppTextString, "Text 1",
                              NULL);
    text2 = spCreateTextArea(container2, "Text 2",
                             SppTextString, "Text 2",
                             NULL);

    return frame;
}

void checkCB(spComponent component, spComponent target)
{
    spBool set;
    
    if (spGetToggleState(component, &set) == SP_TRUE) {
        spSetSensitive(target, set);
    }

    return;
}

int spMain(int argc, char *argv[])
{
    spTopLevel toplevel;
    spComponent main_frame;
    spComponent target_frame;

    /*spSetDebugLevel(20);*/
    
    /* initialize toolkit */
    toplevel = spInitialize(&argc, &argv, NULL);

    /* create main window */
    main_frame = spCreateMainFrame("Sensitive", NULL);

    target_frame = createWindow();
    
    /* create check boxes */
    spCreateCheckBox(main_frame, "Frame",
                     SppSet, SP_TRUE,
                     SppCallbackFunc, checkCB,
                     SppCallbackData, target_frame,
                     SppInitialWidth, 200,
                     NULL);
    spCreateCheckBox(main_frame, "Push Button 1",
                     SppSet, SP_TRUE,
                     SppCallbackFunc, checkCB,
                     SppCallbackData, button1,
                     NULL);
    spCreateCheckBox(main_frame, "Push Button 2",
                     SppSet, SP_TRUE,
                     SppCallbackFunc, checkCB,
                     SppCallbackData, button2,
                     NULL);
    spCreateCheckBox(main_frame, "Scroll Bar",
                     SppSet, SP_TRUE,
                     SppCallbackFunc, checkCB,
                     SppCallbackData, scroll_bar,
                     NULL);
    spCreateCheckBox(main_frame, "Container 1",
                     SppSet, SP_TRUE,
                     SppCallbackFunc, checkCB,
                     SppCallbackData, container1,
                     NULL);
    spCreateCheckBox(main_frame, "Check Box 1",
                     SppSet, SP_TRUE,
                     SppCallbackFunc, checkCB,
                     SppCallbackData, check_box1,
                     NULL);
    spCreateCheckBox(main_frame, "Check Box 2",
                     SppSet, SP_TRUE,
                     SppCallbackFunc, checkCB,
                     SppCallbackData, check_box2,
                     NULL);
    spCreateCheckBox(main_frame, "Container 2",
                     SppSet, SP_TRUE,
                     SppCallbackFunc, checkCB,
                     SppCallbackData, container2,
                     NULL);
    spCreateCheckBox(main_frame, "Text 1",
                     SppSet, SP_TRUE,
                     SppCallbackFunc, checkCB,
                     SppCallbackData, text1,
                     NULL);
    spCreateCheckBox(main_frame, "Text 2",
                     SppSet, SP_TRUE,
                     SppCallbackFunc, checkCB,
                     SppCallbackData, text2,
                     NULL);

    /* create quit button */
    spCreatePushButton(main_frame, "Quit",
                       SppCallbackFunc, spQuitCB,
                       NULL);

    /* popup window */
    spPopupWindow(main_frame);
    spPopupWindow(target_frame);
    
    /* main loop */
    return spMainLoop(toplevel);
}
