#include <stdio.h>
#include <sp/spBaseLib.h>
#include <sp/spComponentLib.h>
#include <sp/spComponentMain.h>

#define JAPANESE_TEST
#if !defined(UTF8_JP_TEST)
#if defined(COCOA) || defined(ANDROID) || defined(GTK2) || defined(GTK3)
#define UTF8_JP_TEST
#endif
#endif

#ifdef JAPANESE_TEST
#if (defined(_WIN32) && !defined(__CYGWIN32__)) || (defined(MACOS) && !defined(COCOA))
#include "strings_sjis.h"
#elif defined(UTF8_JP_TEST)
#include "strings_utf8jp.h"
#else
#include "strings_eucjp.h"
#endif
#else
#define HELLO_STRING "Hello World"
#endif

static spGraphics graphics = NULL;
static char hello_string[] = HELLO_STRING;

static void canvasCB(spComponent component, void *data)
{
    int width = 0, height = 0;
    int sx = 0, sy = 0;
    int swidth = 0, sheight = 0;
    
    spGetSize(component, &width, &height);
    spDebug(20, "canvasCB", "width = %d, height = %d\n", width, height);

    spSetGraphicsParams(graphics, SppForeground, "white", NULL);
    spFillRectangle(component, graphics, 0, 0, width, height);
    
    spSetGraphicsParams(graphics, SppForeground, "red", NULL);

    spDrawLine(component, graphics, 0, 0, width, height);
    spDrawLine(component, graphics, width, 0, 0, height);
    
    spFillRectangle(component, graphics, 80, 80, 100, 50);

    spFillArc(component, graphics, width / 4, height / 4,
              width / 2, height / 2, 0, 45);
    spDrawArc(component, graphics, width / 4, height / 4,
              width / 2, height / 2, 90, 45);
    spFillArc(component, graphics, width / 4, height / 4,
              width / 2, height / 2, 270, -30);

    if (spGetStringExtent(component, graphics, hello_string,
                          &sx, &sy, &swidth, &sheight, NULL) == SP_TRUE) {
        spDrawRectangle(component, graphics, 5 + sx, 50 + sy, swidth, sheight);
    }
    spDrawString(component, graphics, 5, 50, hello_string);
    spSetGraphicsParams(graphics, SppForeground, "blue", NULL);
    spDrawLine(component, graphics, 5, 0, 5, height);
    spDrawLine(component, graphics, 0, 50, width, 50);
    
    spDebug(20, "canvasCB", "done\n");
    
    return;
}

int spMain(int argc, char *argv[])
{
    spTopLevel toplevel;
    spComponent frame;
    spComponent menu, menu_bar;
    spComponent canvas;

    /* initialize toolkit */
    toplevel = spInitialize(&argc, &argv, NULL);
    
    /* create main window */
    frame = spCreateMainFrame("Simple Canvas", NULL);

    /* create menu bar */
    menu_bar = spCreateMenuBar(frame, "menuBar", NULL);
    
    /* create menu */
    menu = spCreatePulldownMenu(menu_bar, "fileMenu",
                                SppTitle, "File",
                                NULL);
    
    /* add menu item */
    spAddMenuItem(menu, SP_QUIT_MENU_ITEM_NAME,
                  SppCallbackFunc, spQuitCB,
                  SppTitle, "Quit",
                  SppShortcut, "A-q",
                  NULL);

    /* create canvas */
    canvas = spCreateCanvas(frame, "canvas", 300, 300,
                            SppBorderOn, SP_TRUE,
                            /*SppDrawBackground, SP_TRUE,*/
                            SppCallbackFunc, canvasCB,
                            NULL);

    graphics = spCreateGraphics("graphics1",
                                SppLineType, SP_LINE_DASH_DOT,
                                SppLineWidth, 1,
                                SppFontName, "-*-*-medium-*-normal--16-*-*-*-*-*-*-*",
                                NULL);
    
    /* popup window */
    spPopupWindow(frame);
    
    /* main loop */
    return spMainLoop(toplevel);
}
