#include <stdio.h>
#include <sp/spBaseLib.h>
#include <sp/spComponentLib.h>
#include <sp/spComponentMain.h>

spComponent status_bar = NULL;

static void helloCB(spComponent component, void *data)
{
    static int count = 0;
    static char *hello_string = "Hello World";
    static char *goodbye_string = "Goodbye World";

    if (count >= 1) {
        if (spQuitPrompt(component) == SP_TRUE) {
            /* quit program */
            spQuit(0);
        } else {
            /* change status text */
            spSetDefaultStatusText(component, hello_string);
        
            /* change label */
            spSetParams(component, SppTitle, hello_string, NULL);
            count = 0;
        }
    } else {
        /* change status text */
        spSetDefaultStatusText(component, goodbye_string);
        
        /* change label */
        spSetParams(component, SppTitle, goodbye_string, NULL);
        count++;
    }
    
    return;
}

static void statusBarCB(spComponent component, void *data)
{
    spBool set;
    
    if (spGetToggleState(component, &set)) {
        if (set == SP_TRUE) {
            spMapComponent(status_bar);
        } else {
            spUnmapComponent(status_bar);
        }
    }
    
    return;
}

int spMain(int argc, char *argv[])
{
    spTopLevel toplevel;
    spComponent frame;
    spComponent menu_bar;
    spComponent menu;
    int sizes[] = {100, 150, 100, 0};

    /*spSetDebugLevel(10);*/
    
    /* initialize toolkit */
    toplevel = spInitialize(&argc, &argv, NULL);
    
    /* create main window */
    frame = spCreateMainFrame("Status Bar", NULL);
    
    /* create menu bar */
    menu_bar = spCreateMenuBar(frame, "menuBar", NULL);
    
    /* create menu */
    menu = spCreatePulldownMenu(menu_bar, "Menu",
                                SppDescription, "Main menu",
                                NULL);
    
    /* add menu item */
    spAddCheckBoxMenuItem(menu, "Show Status Bar",
                          SppCallbackFunc, statusBarCB,
                          SppSet, SP_TRUE,
                          SppDescription, "Show status bar",
                          NULL);

    /* add menu item */
    spAddMenuItem(menu, "Hello World",
                  SppCallbackFunc, helloCB,
                  NULL);

    /* create help menu */
    menu = spCreatePulldownMenu(menu_bar, "Help",
                                SppMenuHelp, SP_TRUE,
                                SppDescription, "Help menu",
                                NULL);
    
    /* add menu item */
    spAddMenuItem(menu, "About",
                  SppCallbackFunc, spDisplayInformationCB,
                  SppCallbackData, "Status Bar version 1.0\nA status bar demo using spComponent",
                  SppDescription, "Get software information",
                  NULL);

    /* create push button */
    spCreatePushButton(frame, "Quit",
                       SppCallbackFunc, spQuitCB,
                       SppInitialWidth, 200,
                       SppDescription, "Quit program",
                       NULL);

    /* create status bar */
    status_bar = spCreateStatusBar(frame, "statusBar",
                                   SppUseLastItem, SP_TRUE,
                                   SppItemSizes, sizes,
                                   SppHelpItemIndex, 1,
                                   NULL);
    spSetDefaultStatusText(frame, "Hello World");
    
    /* popup window */
    spPopupWindow(frame);
    
    /* main loop */
    return spMainLoop(toplevel);
}
