#include <stdio.h>
#include <sp/spBaseLib.h>
#include <sp/spComponentLib.h>
#include <sp/spComponentMain.h>

#define NUM_TRACK_BAR 7
static spComponent text_field = NULL;

static void trackBarCB(spComponent component, void *data)
{
    int value;
    static char buf[SP_MAX_LINE] = "";

    spDebug(10, "trackBarCB", "in\n");
    
    if (spGetSliderValue(component, &value) == SP_TRUE) {
        spDebug(10, NULL, "component: %s, value = %d\n", spGetName(component), value);
        sprintf(buf, "value = %d", value);
        spSetTextString(text_field, buf);
    }
    
    return;
}

static void canvasCB(spComponent component, void *data)
{
    int width = 0, height = 0;
    static spGraphics graphics = NULL;

    if (graphics == NULL) {
        graphics = spCreateGraphics("graphics1",
                                    SppForeground, "red",
                                    SppLineWidth, 1,
                                    NULL);
    }

    spGetSize(component, &width, &height);
    spDebug(10, "canvasCB", "width = %d, height = %d\n", width, height);

    spDrawLine(component, graphics, 0, 0, width, height);
    spDrawLine(component, graphics, width, 0, 0, height);

    spRefreshCanvas(component);

    return;
}

int spMain(int argc, char *argv[])
{
    int i;
    int width;
    char namebuf[SP_MAX_LINE];
    char descbuf[SP_MAX_LINE];
    spTopLevel toplevel;
    spComponent frame;
    spComponent tab_box;
    spComponent tab_item;
    spComponent container;
    spComponent canvas;
    
    /*spSetDebugLevel(100);*/
    
    /* initialize toolkit */
    toplevel = spInitialize(&argc, &argv, NULL);
    
    /* create main window */
    frame = spCreateMainFrame("Tab Box", NULL);

    /* create push button */
    spCreatePushButton(frame, "Quit",
                       SppCallbackFunc, spQuitCB,
                       SppInitialWidth, 200,
                       NULL);

    /* create tab box */
    tab_box = spCreateTabBox(frame, "tabBox", 220,
                             SppSpacingOn, SP_TRUE,
                             NULL);
    
    /* add tab item */
    tab_item = spAddTabItem(tab_box, "Tab Item 1", -1,
                            NULL);
    
    /* create push button */
    spCreatePushButton(tab_item, "Button1",
                       SppCallbackFunc, spSetStatusTextCB,
                       SppCallbackData, "Button1 clicked.",
                       SppInitialWidth, 300,
                       NULL);
    spCreatePushButton(tab_item, "Button1-2",
                       SppCallbackFunc, spSetStatusTextCB,
                       SppCallbackData, "Button1-2 clicked.",
                       NULL);
    spCreatePushButton(tab_item, "Button1-3",
                       SppCallbackFunc, spSetStatusTextCB,
                       SppCallbackData, "Button1-3 clicked.",
                       NULL);

    /* create label */
    spCreateLabel(tab_item, "Label1",
                  NULL);
    
    /* add tab item */
    tab_item = spAddTabItem(tab_box, "Tab Item 2", -1, NULL);
    
    /* create container */
    container = spCreateBox(tab_item, "Container 2", 0,
                            SppOrientation, SP_VERTICAL,
                            SppBorderOn, SP_TRUE,
                            SppTitleOn, SP_TRUE,
                            NULL);
    
    /* create push button */
    spCreatePushButton(container, "Button2",
                       SppCallbackFunc, spSetStatusTextCB,
                       SppCallbackData, "Button2 clicked.",
                       NULL);
    spCreatePushButton(container, "Button2-2",
                       SppCallbackFunc, spSetStatusTextCB,
                       SppCallbackData, "Button2-2 clicked.",
                       NULL);

    /* create label */
    spCreateLabel(container, "Label2-1", NULL);
    spCreateLabel(container, "Label2-2", NULL);
    
    
    /* add tab item */
    tab_item = spAddTabItem(tab_box, "Text Tab", -1, NULL);
    spCreateCheckBox(tab_item, "check box 1",
                     NULL);
    spCreateTextField(tab_item, "text1",
                      SppTextString, "This is text.",
                      NULL);
    spCreateTextField(tab_item, "text2",
                      SppTextString, "This is text.",
                      NULL);
    spCreateTextField(tab_item, "text3",
                      SppTextString, "This is text.",
                      NULL);
    spCreateCheckBox(tab_item, "check box 2",
                     NULL);
    
    /* add tab item */
    tab_item = spAddTabItem(tab_box, "Canvas Tab", -1, NULL);
    
    /* create container */
    container = spCreateBox(tab_item, "Container 3",
                            0,
                            SppOrientation, SP_VERTICAL,
                            SppBorderOn, SP_TRUE,
                            SppTitleOn, SP_TRUE,
                            NULL);
    
    /* create canvas */
    canvas = spCreateCanvas(container, "canvas",
                            600, 300,
                            SppBorderOn, SP_TRUE,
                            SppCallbackFunc, canvasCB,
                            SppDrawBackground, SP_TRUE,
                            NULL);
    
    /* add tab item */
    tab_item = spAddTabItem(tab_box, "Slider Tab", -1, NULL);
    
    spCreatePushButton(tab_item, "Button5",
                       SppCallbackFunc, spSetStatusTextCB,
                       SppCallbackData, "Button5 clicked.",
                       SppInitialWidth, 300,
                       NULL);
    text_field = spCreateTextField(tab_item, "textField",
                                   SppEditable, SP_FALSE,
                                   SppDescription, "Text field to indicate track bar's value.",
                                   NULL);
    
    /* create container */
    container = spCreateBox(tab_item, "trackBarContainer", 0,
                            SppOrientation, SP_HORIZONTAL,
                            NULL);
    /* create track bars */
    width = (int)spRound(100.0 / (double)NUM_TRACK_BAR);
    for (i = 1; i <= NUM_TRACK_BAR; i++) {
        sprintf(namebuf, "trackBar%d", i);
        sprintf(descbuf, "This is track bar %d.", i);
        spCreateTrackBar(container, namebuf,
                         SppOrientation, SP_VERTICAL,
                         SppCallbackFunc, trackBarCB,
                         SppTrackCallbackOn, SP_TRUE,
                         SppShowScale, SP_TRUE,
                         SppShowValue, SP_TRUE,
                         SppPercentageWidth, width,
                         SppReversed, SP_TRUE,
                         SppDescription, descbuf,
                         NULL);
    }
    
    /* create status bar */
    spCreateStatusBar(frame, "statusBar", NULL);
    
    /* popup window */
    spPopupWindow(frame);
    
    /* main loop */
    return spMainLoop(toplevel);
}
