#include <stdio.h>
#include <sp/spBaseLib.h>
#include <sp/spComponentLib.h>
#include <sp/spComponentMain.h>

int spMain(int argc, char *argv[])
{
    spTopLevel toplevel;
    spComponent frame;
    spComponent menu;

    /*spSetDebugLevel(30);*/

    /* initialize toolkit */
    toplevel = spInitialize(&argc, &argv, NULL);
    
    /* create main window */
    frame = spCreateMainFrame("Task Tray",
                              SppTaskTrayVisible, SP_TRUE,
                              SppTaskTrayTip, "This is task tray.",
                              NULL);

    /* create popup menu */
    if ((menu = spCreateTaskTrayPopup(frame, "Menu", NULL)) != NULL) {
        /* add menu item */
        spAddMenuItem(menu, "Display Message",
                      SppCallbackFunc, spDisplayMessageCB,
                      SppCallbackData, "A menu item in task tray is clicked.",
                      NULL);
        spAddMenuItem(menu, "Quit",
                      SppCallbackFunc, spQuitCB,
                      NULL);
        
        /* show task tray */
        spShowTaskTray(frame, SP_TRUE);
    } else {
        /* create push button */
        spCreatePushButton(frame, "Quit",
                           SppCallbackFunc, spQuitCB,
                           NULL);

        /* popup window */
        spPopupWindow(frame);
        
        /* display error */
        spDisplayError(frame, NULL, "Task tray is not supported.");
    }
    
    /* main loop */
    return spMainLoop(toplevel);
}
