#include <stdio.h>
#include <sp/spBaseLib.h>
#include <sp/spComponentLib.h>
#include <sp/spComponentMain.h>

static spComponent text = NULL;

static long timer_interval = 500;
static spTimerId timer_id = SP_TIMER_ID_NONE;

static spBool timerCB(spComponent frame, void *data)
{
    char buf[SP_MAX_LINE];
    long *count = (long *)data;
    
    *count += timer_interval;
    spDebug(100, "timerCB", "count = %ld\n", *count);

    sprintf(buf, "%ld", *count);
    
    spSetTextString(text, buf);
    
    return SP_TRUE;
}
     
static void checkBoxCB(spComponent component, long *count)
{
    spBool set;
    spComponent frame;

    if (spGetToggleState(component, &set)) {
        frame = spGetWindow(component);
    
        if (set == SP_TRUE) {
            *count = 0;
            timer_id = spSetTimer(frame, timer_interval, timerCB, count);
        } else {
            if (timer_id != SP_TIMER_ID_NONE) {
                spKillTimer(frame, timer_id);
                timer_id = SP_TIMER_ID_NONE;
            }
        }
    }
    
    return;
}

static long count = 0;

static spBool toplevelCB(spTopLevel toplevel, spTopLevelCallbackReason reason, void *data)
{
    spComponent frame;
    
    spDebug(10, "toplevelCB", "reason = %d\n", reason);

    frame = (spComponent)data;

    if (reason == SP_TL_CR_INACTIVE) {
        if (timer_id != SP_TIMER_ID_NONE) {
            spKillTimer(frame, timer_id);
        }
    } else if (reason == SP_TL_CR_ACTIVE) {
        if (timer_id != SP_TIMER_ID_NONE) {
            timer_id = spSetTimer(frame, timer_interval, timerCB, &count);
        }
    }

    return SP_TRUE;
}

int spMain(int argc, char *argv[])
{
    spTopLevel toplevel;
    spComponent frame;
    spComponent menu, menu_bar;

    count = 0;
    timer_id = SP_TIMER_ID_NONE;

    /* initialize toolkit */
    toplevel = spInitialize(&argc, &argv,
                            SppTopLevelCallbackFunc, toplevelCB,
                            NULL);
    
    /* create main window */
    frame = spCreateMainFrame("Timer Test", NULL);
    spSetTopLevelParams(toplevel,
                        SppTopLevelCallbackData, frame,
                        NULL);

    /* create menu bar */
    menu_bar = spCreateMenuBar(frame, "menuBar", NULL);
    
    /* create menu */
    menu = spCreatePulldownMenu(menu_bar, "fileMenu",
                                SppTitle, "File",
                                NULL);
    
    /* add menu item */
    spAddMenuItem(menu, SP_QUIT_MENU_ITEM_NAME,
                  SppCallbackFunc, spQuitCB,
                  SppTitle, "Quit",
                  SppShortcut, "A-q",
                  NULL);

    /* create check box */
    spCreateCheckBox(frame, "timerOnCheckBox",
                     SppTitle, "Timer On",
                     SppCallbackFunc, checkBoxCB,
                     SppCallbackData, &count,
                     NULL);

    /* create text field */
    text = spCreateTextField(frame, "text",
                             SppEditable, SP_FALSE,
                             SppTextString, "0",
                             NULL);

    /* popup window */
    spPopupWindow(frame);
    
    return spMainLoop(toplevel);
}
