#include <stdio.h>
#include <sp/spBaseLib.h>
#include <sp/spComponentLib.h>
#include <sp/spComponentMain.h>

static void toggleCB(spComponent component, int num)
{
    spBool set;
    
    if (spGetToggleState(component, &set)) {
        if (set == SP_TRUE) {
            printf("Toggle Menu Item %d: Checked\n", num);
        } else {
            printf("Toggle Menu Item %d: Unchecked\n", num);
        }
    }
    
    return;
}

int spMain(int argc, char *argv[])
{
    spTopLevel toplevel;
    spComponent frame;
    spComponent menu_bar;
    spComponent file_menu, menu;

    /*spSetDebugLevel(50);*/
    
    /* initialize toolkit */
    toplevel = spInitialize(&argc, &argv, NULL);
    
    /* create main window */
    frame = spCreateMainFrame("Toggle Menu", NULL);
    
    /* create menu bar */
    menu_bar = spCreateMenuBar(frame, "menuBar", NULL);
    
    /* create file menu */
    file_menu = spCreatePulldownMenu(menu_bar, "File", NULL);
    
    /* add sub menu */
    /*menu = spAddSubMenu(file_menu, "Check Box", NULL);*/
    menu = spAddSubMenu(menu_bar, "Check Box", NULL);
    
    /* add check box menu item */
    spAddCheckBoxMenuItem(menu, "Check Box 1",
                          SppCallbackFunc, toggleCB,
                          SppCallbackData, 1,
                          SppShortcut, "A-1",
                          NULL);
    spAddCheckBoxMenuItem(menu, "Check Box 2",
                          SppCallbackFunc, toggleCB,
                          SppCallbackData, 2,
                          SppShortcut, "A-2",
                          NULL);
    spAddCheckBoxMenuItem(menu, "Check Box 3",
                          SppCallbackFunc, toggleCB,
                          SppCallbackData, 3,
                          SppShortcut, "A-3",
                          NULL);

    /* add sub menu */
    /*menu = spAddSubMenu(file_menu, "Radio Button", NULL);*/
    menu = spAddSubMenu(menu_bar, "Radio Button", NULL);
    
    /* add radio button menu item */
    spAddRadioButtonMenuItem(menu, "Radio Button 1",
                             SppSet, SP_TRUE,
                             SppCallbackFunc, toggleCB,
                             SppCallbackData, 1,
                             SppShortcut, "S-1",
                             NULL);
    spAddRadioButtonMenuItem(menu, "Radio Button 2",
                             SppCallbackFunc, toggleCB,
                             SppCallbackData, 2,
                             SppShortcut, "S-2",
                             NULL);
    spAddRadioButtonMenuItem(menu, "Radio Button 3",
                             SppCallbackFunc, toggleCB,
                             SppCallbackData, 3,
                             SppShortcut, "S-3",
                             SppRadioEnd, SP_TRUE,
                             NULL);
    spAddMenuSeparator(menu, "radioSeparator", NULL);
    spAddRadioButtonMenuItem(menu, "Radio Button 2-1",
                             SppSet, SP_TRUE,
                             SppCallbackFunc, toggleCB,
                             SppCallbackData, 4,
                             SppShortcut, "S-4",
                             NULL);
    spAddRadioButtonMenuItem(menu, "Radio Button 2-2",
                             SppCallbackFunc, toggleCB,
                             SppCallbackData, 5,
                             SppShortcut, "S-5",
                             NULL);
    spAddRadioButtonMenuItem(menu, "Radio Button 3-3",
                             SppCallbackFunc, toggleCB,
                             SppCallbackData, 6,
                             SppShortcut, "S-6",
                             NULL);
    
    /* add menu separator */
    /*spAddMenuSeparator(file_menu, "QuitSeparator", NULL);*/
    
    /* add menu item */
    spAddMenuItem(file_menu, SP_QUIT_MENU_ITEM_NAME,
                  SppCallbackFunc, spQuitCB,
                  SppShortcut, "A-q",
                  NULL);

    /* create help menu */
    menu = spCreatePulldownMenu(menu_bar, "Help",
                                SppMenuHelp, SP_TRUE,
                                NULL);
    
    /* add menu item */
    spAddMenuItem(menu, "About",
                  SppCallbackFunc, spDisplayInformationCB,
                  SppCallbackData, "Toggle Menu version 1.1\nA menu demo with toggle buttons using spComponent",
                  NULL);

    /* create push button */
    spCreatePushButton(frame, "Quit",
                       SppCallbackFunc, spQuitCB,
                       SppInitialWidth, 200, 
                       NULL);

    /* popup window */
    spPopupWindow(frame);
    
    /* main loop */
    return spMainLoop(toplevel);
}
