#include <stdio.h>
#include <sp/spBaseLib.h>
#include <sp/spComponentLib.h>
#include <sp/spComponentMain.h>

#ifdef MACOS
static char * tool_bar_xpm[] = {"", ""};
#else
#include "tool_bar.xpm"
#endif

static void showToolBarCB(spComponent component, spComponent tool_bar)
{
    spBool set;
    
    if (spGetToggleState(component, &set)) {
        if (set == SP_TRUE) {
            spMapComponent(tool_bar);
        } else {
            spUnmapComponent(tool_bar);
        }
    }
    
    return;
}

static void checkToolItemCB(spComponent component, void *data)
{
    spBool set;
    
    if (spGetToggleState(component, &set)) {
        if (set == SP_TRUE) {
            spDisplayMessage(component, NULL, "Tool item checked.");
        } else {
            spDisplayMessage(component, NULL, "Tool item unchecked.");
        }
    }
    
    return;
}

int spMain(int argc, char *argv[])
{
    spTopLevel toplevel;
    spComponent frame;
    spComponent tool_bar;
    spComponent tool_item;
    
    /*spSetDebugLevel(10);*/
    
    /* initialize toolkit */
    toplevel = spInitialize(&argc, &argv, NULL);
    
    /* create main window */
    frame = spCreateMainFrame("Tool Bar", NULL);
    
    tool_bar = spCreateToolBar(frame, "tool_bar", 5,
                               SppBitmapData, tool_bar_xpm,
                               NULL);
    tool_item = spAddCheckToolItem(tool_bar, NULL,
                                   SppCallbackFunc, checkToolItemCB,
                                   SppDescription, "Tool Item 1",
                                   NULL);
    tool_item = spAddToolItem(tool_bar, NULL,
                              SppCallbackFunc, spDisplayMessageCB,
                              SppCallbackData, "Tool item 2 clicked.",
                              SppDescription, "Tool Item 2",
                              NULL);
    tool_item = spAddToolItem(tool_bar, NULL,
                              SppCallbackFunc, spDisplayMessageCB,
                              SppCallbackData, "Tool item 3 clicked.",
                              SppDescription, "Tool Item 3",
                              SppSenseLevel, 1,
                              NULL);
    spAddToolSeparator(tool_bar, NULL, NULL);
    tool_item = spAddToolItem(tool_bar, NULL,
                              SppCallbackFunc, spDisplayMessageCB,
                              SppCallbackData, "Tool item 4 clicked.",
                              SppDescription, "Tool Item 4",
                              NULL);
    tool_item = spAddToolItem(tool_bar, NULL,
                              SppCallbackFunc, spDisplayMessageCB,
                              SppCallbackData, "Tool item 5 clicked.",
                              SppDescription, "Tool Item 5",
                              NULL);
    
    /* create check box */
    spCreateCheckBox(frame, "Show Tool Bar",
                     SppCallbackFunc, showToolBarCB,
                     SppCallbackData, tool_bar,
                     SppSet, SP_TRUE,
                     NULL);
    
    /* create push button */
    spCreatePushButton(frame, "Quit",
                       SppCallbackFunc, spQuitCB,
                       SppInitialWidth, 200,
                       NULL);
    
    /* popup window */
    spPopupWindow(frame);
    
    /* main loop */
    return spMainLoop(toplevel);
}
