#include <stdio.h>
#include <sp/spBaseLib.h>
#include <sp/spComponentLib.h>
#include <sp/spComponentMain.h>

static spComponent track_bar = NULL;
static spComponent track_bar2 = NULL;
static spComponent text_field = NULL;

static void trackBarCB(spComponent component, void *data)
{
    int value;
    static char buf[SP_MAX_LINE] = "";

    spDebug(10, "trackBarCB", "in\n");
    
    if (spGetSliderValue(component, &value) == SP_TRUE) {
        spDebug(10, NULL, "component: %s, value = %d\n", spGetName(component), value);
        sprintf(buf, "value = %d", value);
        spSetTextString(text_field, buf);
    }
    
    return;
}

int spMain(int argc, char *argv[])
{
    spTopLevel toplevel;
    spComponent frame;

    /*spSetDebugLevel(100);*/
    
    /* initialize toolkit */
    toplevel = spInitialize(&argc, &argv, NULL);
    
    /* create main window */
    frame = spCreateMainFrame("Track Bar", NULL);

    /* create track bar */
    track_bar = spCreateTrackBar(frame, "trackBar",
                                 SppCallbackFunc, trackBarCB,
                                 SppShowScale, SP_TRUE,
                                 SppShowValue, SP_TRUE,
                                 SppMinimum, 0,
                                 SppMaximum, 300,
                                 SppDescription, "This is track bar 1.",
                                 NULL);

    /* create track bar */
    track_bar2 = spCreateTrackBar(frame, "trackBar2",
                                  SppCallbackFunc, trackBarCB,
                                  SppShowScale, SP_TRUE,
                                  SppShowValue, SP_TRUE,
                                  SppMinimum, -100,
                                  SppMaximum, 100,
                                  SppValue, -80,
                                  SppDecimalPoints, 3,
                                  SppDescription, "This is track bar 2.",
                                  NULL);

    /* create text field */
    text_field = spCreateTextField(frame, "textField",
                                   SppEditable, SP_FALSE,
                                   SppDescription, "Text field to indicate track bar's value.",
                                   NULL);

    /* popup window */
    spPopupWindow(frame);
    
    /* main loop */
    return spMainLoop(toplevel);
}
