#include <stdio.h>
#include <sp/spBaseLib.h>
#include <sp/spComponentLib.h>
#include <sp/spComponentMain.h>

static spComponent track_bar = NULL;
static spComponent text_field = NULL;
static spBool track_call_on = SP_FALSE;

static void trackBarCB(spComponent component, void *data)
{
    int value;
    static char buf[SP_MAX_LINE] = "";

    if (spGetSliderValue(component, &value) == SP_TRUE) {
        sprintf(buf, "value = %d", value);
        spSetTextString(text_field, buf);
        spDebug(10, "trackBarCB", "value = %d, buf = %s\n", value, buf);
        if (track_call_on == SP_FALSE) {
            spDisplayMessage(component, NULL, buf);
        }
    }
    
    spDebug(10, "trackBarCB", "done\n");
    
    return;
}

static void checkCB(spComponent component, void *data)
{
    spGetToggleState(component, &track_call_on);

    spSetParams(track_bar, SppTrackCallbackOn, track_call_on, NULL);

    return;
}

int spMain(int argc, char *argv[])
{
    spTopLevel toplevel;
    spComponent frame;

    spSetDebugLevel(100);
    
    /* initialize toolkit */
    toplevel = spInitialize(&argc, &argv, NULL);
    
    /* create main window */
    frame = spCreateMainFrame("Track Bar 2", NULL);

    /* create check box */
    spCreateCheckBox(frame, "Track Callback",
                     SppSet, track_call_on,
                     SppCallbackFunc, checkCB,
                     NULL);

    /* create track bar */
    track_bar = spCreateTrackBar(frame, "trackBar", NULL);
    spAddCallback(track_bar, SP_VALUE_CHANGED_CALLBACK, (spCallbackFunc)trackBarCB, NULL);

    /* create text field */
    text_field = spCreateTextField(frame, "textField",
                                   SppEditable, SP_FALSE,
                                   NULL);

    /* popup window */
    spPopupWindow(frame);
    
    /* main loop */
    return spMainLoop(toplevel);
}
