#include <stdio.h>
#include <sp/spBaseLib.h>
#include <sp/spComponentLib.h>
#include <sp/spComponentMain.h>

#define NUM_WINDOW 4

static void canvasCB(spComponent component, void *data)
{
    int width = 0, height = 0;
    spGraphics graphics = (spGraphics)data;
    
    if (spGetSize(component, &width, &height) == SP_FALSE) return;
    
    spDebug(20, "canvasCB", "width = %d, height = %d\n", width, height);

    spSetGraphicsParams(graphics, SppForeground, "white", NULL);
    spFillRectangle(component, graphics, 0, 0, width, height);

    spSetGraphicsParams(graphics, SppForeground, "black", NULL);
    spDrawLine(component, graphics, 0, 0, width, height);
    spDrawLine(component, graphics, 0, height, width, 0);
    
    /*spRefreshCanvas(component);*/
    
    spDebug(20, "canvasCB", "done\n");
    
    return;
}

int spMain(int argc, char *argv[])
{
    int i;
    spTopLevel toplevel;
    spComponent frames[NUM_WINDOW];
    spComponent canvas;
    spComponent menu;
    spGraphics graphics;

    /* initialize toolkit */
    toplevel = spInitialize(&argc, &argv, NULL);

    graphics = spCreateGraphics("graphics1",
                                SppLineType, SP_LINE_DASH_DOT,
                                SppLineWidth, 1,
                                NULL);
    
    for (i = 0; i < NUM_WINDOW; i++) {
        /* create frame */
        frames[i] = spCreateFrame("Transient Windows",
                                  SppWindowType, SP_TRANSIENT_WINDOW,
                                  NULL);

        /* create canvas */
        canvas = spCreateCanvas(frames[i], "canvas", 300, 300,
                                SppBorderOn, SP_TRUE,
                                SppCallbackFunc, canvasCB,
                                SppCallbackData, graphics,
                                NULL);
        spSetCanvasCapture(canvas, SP_TRUE);
    
        /* create popup menu */
        menu = spCreatePopupMenu(canvas, "Menu",
                                 SppPopupButton, SP_RBUTTON,
                                 NULL);
        
        /* add menu item */
        spAddMenuItem(menu, "Close",
                      SppCallbackFunc, spCloseWindowCB,
                      SppShortcut, "A-w",
                      NULL);

        /* popup window */
        spPopupWindow(frames[i]);
    }
    
    /* main loop */
    return spMainLoop(toplevel);
}
