#include <stdio.h>
#include <sp/spBaseLib.h>
#include <sp/spComponentLib.h>
#include <sp/spComponentMain.h>

static spComponent track_bar = NULL;
static spComponent track_bar2 = NULL;
static spComponent track_bar3 = NULL;
static spComponent text_field = NULL;
static spBool track_call_on = SP_FALSE;

static void trackBarCB(spComponent component, void *data)
{
    int value;
    static char buf[SP_MAX_LINE] = "";

    spDebug(10, "trackBarCB", "in\n");
    
    if (spGetSliderValue(component, &value) == SP_TRUE) {
        spDebug(10, NULL, "component: %s, value = %d\n", spGetName(component), value);
        sprintf(buf, "value = %d", value);
        spSetTextString(text_field, buf);
        spDebug(10, "trackBarCB", "value = %d, buf = %s\n", value, buf);
        if (track_call_on == SP_FALSE) {
            spDisplayMessage(component, NULL, buf);
        }
    }
    
    spDebug(10, "trackBarCB", "done\n");
    
    return;
}

static void checkCB(spComponent component, void *data)
{
    spGetToggleState(component, &track_call_on);

    spSetParams(track_bar, SppTrackCallbackOn, track_call_on, NULL);
    spSetParams(track_bar2, SppTrackCallbackOn, track_call_on, NULL);
    spSetParams(track_bar3, SppTrackCallbackOn, track_call_on, NULL);

    return;
}

int spMain(int argc, char *argv[])
{
    spTopLevel toplevel;
    spComponent frame;
    spComponent box;

    /*spSetDebugLevel(100);*/
    
    /* initialize toolkit */
    toplevel = spInitialize(&argc, &argv, NULL);
    
    /* create main window */
    frame = spCreateMainFrame("Vertical Track Bar", NULL);

    /* create check box */
    spCreateCheckBox(frame, "Track Callback",
                     SppSet, track_call_on,
                     SppCallbackFunc, checkCB,
                     NULL);

    /* create box */
    box = spCreateBox(frame, "box", -spGetTextFieldDefaultHeight(SP_TRUE),
                      SppOrientation, SP_HORIZONTAL,
                      NULL);
    
    /* create track bar */
    track_bar = spCreateTrackBar(box, "trackBar",
                                 SppOrientation, SP_VERTICAL,
                                 SppCallbackFunc, trackBarCB,
                                 SppShowScale, SP_TRUE,
                                 SppShowValue, SP_TRUE,
                                 SppReversed, SP_TRUE,
                                 SppMinimum, -500,
                                 SppMaximum, 300,
                                 SppDescription, "This is track bar 1.",
                                 SppPercentageWidth, 33,
                                 NULL);

    /* create track bar */
    track_bar2 = spCreateTrackBar(box, "trackBar2",
                                  SppOrientation, SP_VERTICAL,
                                  SppCallbackFunc, trackBarCB,
                                  SppShowScale, SP_TRUE,
                                  SppShowValue, SP_TRUE,
                                  SppMinimum, -100,
                                  SppMaximum, 100,
                                  SppDecimalPoints, 3,
                                  SppDescription, "This is track bar 2.",
                                  SppPercentageWidth, 33,
                                  NULL);

    /* create track bar */
    track_bar3 = spCreateTrackBar(box, "trackBar3",
                                  SppOrientation, SP_VERTICAL,
                                  SppCallbackFunc, trackBarCB,
                                  SppShowScale, SP_TRUE,
                                  SppShowValue, SP_TRUE,
                                  SppDescription, "This is track bar 3.",
                                  SppPercentageWidth, 33,
                                  NULL);

    /* create text field */
    text_field = spCreateTextField(frame, "textField",
                                   SppEditable, SP_FALSE,
                                   SppDescription, "Text field to indicate track bar's value.",
                                   NULL);

    /* popup window */
    spPopupWindow(frame);
    
    /* main loop */
    return spMainLoop(toplevel);
}
