#   File:       cube-ppc.make
#   Target:     cube-ppc
#   Created:    Monday, August 7, 2000 01:35:33 AM


MAKEFILE        = cube-ppc.make
MondoBuild    = {MAKEFILE}  # Make blank to avoid rebuilds when makefile is modified

SpBaseDir  	= :::spBase:
SpComponentDir  = :::spComponent:
SpComponentExDir = ::
SpLibDir  	= :::lib:

ObjDir          = :
Includes        =  
				  -i {SpComponentExDir} 
				  -i {SpComponentDir} 
				  -i {SpBaseDir}

Sym-PPC         = -sym off

PPCCOptions     = {Includes} {Sym-PPC} -includes unix -enum int -j0


### Source Files ###

SrcFiles        =  
				  cube.c


### Object Files ###

ObjFiles-PPC    =  
				  "{ObjDir}cube.c.x"


### Libraries ###

LibFiles-PPC    =  
				  "{SpLibDir}spComponentEx-ppc.o" 
				  "{SpLibDir}spComponent-ppc.o" 
				  "{SpLibDir}spBase-ppc.o" 
				  "{SharedLibraries}OpenGLUtilityStub" 
				  "{SharedLibraries}OpenGLMemoryStub" 
				  "{SharedLibraries}OpenGLLibraryStub" 
				  "{SharedLibraries}ThreadsLib" 
				  "{SharedLibraries}NavigationLib" 
				  "{SharedLibraries}FontManager" 
				  "{SharedLibraries}ControlsLib" 
				  "{SharedLibraries}WindowsLib" 
				  "{SharedLibraries}AppearanceLib" 
				  "{SharedLibraries}InterfaceLib" 
				  "{SharedLibraries}TextEncodingConverter" 
				  "{SharedLibraries}StdCLib" 
				  "{SharedLibraries}MathLib" 
				  "{PPCLibraries}StdCRuntime.o" 
				  "{PPCLibraries}PPCCRuntime.o" 
				  "{PPCLibraries}PPCToolLibs.o"


### Default Rules ###

.c.x    .c  {MondoBuild}
	{PPCC} {depDir}{default}.c -o {targDir}{default}.c.x {PPCCOptions}


### Build Rules ###

cube-ppc    {ObjFiles-PPC} {LibFiles-PPC} {MondoBuild}
	PPCLink 
		-o {Targ} 
		{ObjFiles-PPC} 
		{LibFiles-PPC} 
		{Sym-PPC} -weaklib ControlsLib,WindowsLib,AppearanceLib,TextEncodingConverter 
		-mf -d 
		-t 'APPL' 
		-c '????'



### Required Dependencies ###

"{ObjDir}cube.c.x"    cube.c


### Optional Dependencies ###
### Build this target to generate "include file" dependencies. ###

Dependencies    $OutOfDate
	MakeDepend 
		-append {MAKEFILE} 
		-ignore "{CIncludes}" 
		-objdir "{ObjDir}" 
		-objext .x 
		{Includes} 
		{SrcFiles}


