/*
 * spComponentEx  OpenGL sample code  by Hideki Banno
 *
 * Original version is from:
 *   Tokoi-sensei's webpage (http://www.wakayama-u.ac.jp/~tokoi/opengl/libglut.html)
 */

#include <math.h>
#include <sp/spComponentLib.h>
#include <sp/spGL.h>
#include <sp/spComponentMain.h>

spTimerId timer_id = SP_TIMER_ID_NONE;
long timer_interval = 5;
spComponent canvas = NULL;

spGLContext context;

GLdouble vertex[][3] = {
    { 0.0, 0.0, 0.0 },
    { 1.0, 0.0, 0.0 },
    { 1.0, 1.0, 0.0 },
    { 0.0, 1.0, 0.0 },
    { 0.0, 0.0, 1.0 },
    { 1.0, 0.0, 1.0 },
    { 1.0, 1.0, 1.0 },
    { 0.0, 1.0, 1.0 }
};

int face[][4] = {
    { 0, 1, 2, 3 },
    { 1, 5, 6, 2 },
    { 5, 4, 7, 6 },
    { 4, 0, 3, 7 },
    { 4, 5, 1, 0 },
    { 3, 2, 6, 7 }
};

GLdouble normal[][3] = {
    { 0.0, 0.0,-1.0 },
    { 1.0, 0.0, 0.0 },
    { 0.0, 0.0, 1.0 },
    {-1.0, 0.0, 0.0 },
    { 0.0,-1.0, 0.0 },
    { 0.0, 1.0, 0.0 }
};

GLfloat light0pos[] = { 0.0, 3.0, 5.0, 1.0 };
GLfloat light1pos[] = { 5.0, 3.0, 0.0, 1.0 };

GLfloat green[] = { 0.0, 1.0, 0.0, 1.0 };
GLfloat red[] = { 0.8, 0.2, 0.2, 1.0 };
GLfloat blue[] = { 0.2, 0.2, 0.8, 1.0 };

void cube(void)
{
  int i;
  int j;

  glBegin(GL_QUADS);
  for (j = 0; j < 6; ++j) {
    glNormal3dv(normal[j]);
    for (i = 0; i < 4; ++i) {
      glVertex3dv(vertex[face[j][i]]);
    }
  }
  glEnd();
}

void display(spComponent component)
{
  static int r = 0; /* ]p */

  glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);

  /* ̈ʒuݒ */
  glLightfv(GL_LIGHT0, GL_POSITION, light0pos);
  glLightfv(GL_LIGHT1, GL_POSITION, light1pos);

  /* fr[ϊs̕ۑ */
  glPushMatrix();

  /* }`̉] */
  glRotatef((GLfloat)r, 0.0, 1.0, 0.0);

  /* }`̐F ()  */
  glMaterialfv(GL_FRONT_AND_BACK, GL_DIFFUSE, red);

  /* }`̕` */
  cube();

  /* ڂ̐}`̕` */
  glPushMatrix();
  glTranslatef(1.0, 1.0, 1.0);
  glRotatef((GLfloat)(2 * r), 0.0, 1.0, 0.0);
  glMaterialfv(GL_FRONT_AND_BACK, GL_DIFFUSE, blue);
  cube();
  glPopMatrix();

  /* fr[ϊs̕A */
  glPopMatrix();

  spGLSwapBuffers(component);

  /* ]p 0 ɖ߂ */
  if (++r >= 360) r = 0;
}

void resize(int w, int h)
{
  spDebug(10, "resize", "w = %d, h = %d\n", w, h);
  
  glViewport(0, 0, w, h);

  /* ϊs̐ݒ */
  glMatrixMode(GL_PROJECTION);
  glLoadIdentity();
  gluPerspective(30.0, (double)w / (double)h, 1.0, 100.0);

  /* fr[ϊs̐ݒ */
  glMatrixMode(GL_MODELVIEW);
  glLoadIdentity();
  gluLookAt(3.0, 4.0, 5.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0);
}

static spBool timerCB(spComponent frame, void *data)
{
  spDebug(10, "timerCB", "in\n");
  spRefreshCanvas(canvas);
  return SP_TRUE;
}

void mouse(spComponent component, void *data)
{
  spCallbackReason reason;
  int *do_animation = (int *)data;

  reason = spGetCallbackReason(component);

  switch (reason) {
  case SP_CR_LBUTTON_PRESS:
    /* Aj[VJn */
    *do_animation = 1;
    spDebug(10, "mouse", "set timer\n");
    timer_id = spSetTimer(canvas, timer_interval, timerCB, NULL);
    break;
  case SP_CR_LBUTTON_RELEASE:
    /* Aj[V~ */
    *do_animation = 0;
    if (timer_id != SP_TIMER_ID_NONE) {
      spDebug(10, "mouse", "kill timer\n");
      spKillTimer(canvas, timer_id);
    }
    break;

  case SP_CR_RBUTTON_PRESS:
    /* R} (PXebvi߂) */
    spRefreshCanvas(component);
    break;

  default:
    break;
  }
}

void keyboard(spComponent component, void *data)
{
  spKeySym code;
  
  if (spGetCallbackKeySym(component, &code) == SP_TRUE
      && code == SPK_Escape) {
    spQuit(0);
  }
}
void init(void)
{
  glClearColor(1.0, 1.0, 1.0, 1.0);

  glEnable(GL_DEPTH_TEST);

  glEnable(GL_CULL_FACE);
  glCullFace(GL_FRONT);

  glEnable(GL_LIGHTING);
  glEnable(GL_LIGHT0);
  glEnable(GL_LIGHT1);
  glLightfv(GL_LIGHT1, GL_DIFFUSE, green);
  glLightfv(GL_LIGHT1, GL_SPECULAR, green);
  spDebug(10, "init", "done\n");
}

void canvasCB(spComponent component, void *data)
{
  int *init_flag = (int *)data;
  int w = 0, h = 0;
  spCallbackReason reason;
  
  reason = spGetCallbackReason(component);

  spDebug(10, "canvasCB", "reason = %d\n", reason);
  
  if (reason == SP_CR_RESIZE || *init_flag == 0) {
    if (*init_flag == 0) {
      init();
      *init_flag = 1;
    }
    if (spGetSize(component, &w, &h) == SP_FALSE) return;
  
    resize(w, h);
    /*spGLSwapBuffers(component);*/
  }
  display(component);
}

static int init_flag = 0;
static int do_animation = 0;

int spMain(int argc, char *argv[])
{
  spTopLevel toplevel;
  spComponent window;
  spGLVisual visual;
  spGLAttribute attribs[] = { SP_GL_RGBA,
                              SP_GL_DOUBLEBUFFER,
                              SP_GL_DEPTH_SIZE, 1,
                              SP_GL_NONE };

  /*spSetDebugLevel(100);*/

  init_flag = 0;
  do_animation = 0;
  
  toplevel = spInitialize(&argc, &argv, NULL);

  visual = spCreateGLVisual(toplevel, attribs);

  window = spCreateMainFrame("Cube 2", NULL);
  canvas = spCreateGLCanvas(window, "canvas", visual, 300, 300,
                            SppTitle, argv[0],
                            SppCallbackFunc, canvasCB,
                            SppCallbackData, &init_flag,
                            NULL);
  spAddCallback(canvas, SP_BUTTON_PRESS_CALLBACK | SP_BUTTON_RELEASE_CALLBACK,
                mouse, &do_animation);
  spAddCallback(canvas, SP_KEY_PRESS_CALLBACK, keyboard, NULL);
  
  context = spCreateGLContext(canvas, NULL);

  spPopupWindow(window);
  
  spSetGLContext(canvas, context);
  
  return spMainLoop(toplevel);
}
