/*
 * spComponentEx  OpenGL sample code  by Hideki Banno
 *
 * Original version is from:
 *   Tokoi-sensei's webpage (http://www.wakayama-u.ac.jp/~tokoi/opengl/libglut.html)
 */

#include <math.h>
#include <sp/spComponentLib.h>
#include <sp/spGL.h>
#include <sp/spComponentMain.h>

spGLContext context1, context2;

GLdouble vertex[][3] = {
    { 0.0, 0.0, 0.0 },
    { 1.0, 0.0, 0.0 },
    { 1.0, 1.0, 0.0 },
    { 0.0, 1.0, 0.0 },
    { 0.0, 0.0, 1.0 },
    { 1.0, 0.0, 1.0 },
    { 1.0, 1.0, 1.0 },
    { 0.0, 1.0, 1.0 }
};

int face[][4] = {
    { 0, 1, 2, 3 },
    { 1, 5, 6, 2 },
    { 5, 4, 7, 6 },
    { 4, 0, 3, 7 },
    { 4, 5, 1, 0 },
    { 3, 2, 6, 7 }
};

GLdouble normal[][3] = {
    { 0.0, 0.0,-1.0 },
    { 1.0, 0.0, 0.0 },
    { 0.0, 0.0, 1.0 },
    {-1.0, 0.0, 0.0 },
    { 0.0,-1.0, 0.0 },
    { 0.0, 1.0, 0.0 }
};

GLfloat light0pos[] = { 0.0, 3.0, 5.0, 1.0 };
GLfloat light1pos[] = { 5.0, 3.0, 0.0, 1.0 };

GLfloat green[] = { 0.0, 1.0, 0.0, 1.0 };
GLfloat red[] = { 0.8, 0.2, 0.2, 1.0 };

void cube(void)
{
  int i;
  int j;

  glBegin(GL_QUADS);
  for (j = 0; j < 6; ++j) {
    glNormal3dv(normal[j]);
    for (i = 0; i < 4; ++i) {
      glVertex3dv(vertex[face[j][i]]);
    }
  }
  glEnd();
}

void display(spComponent component, int *r)
{
  glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);

  /* ̈ʒuݒ */
  glLightfv(GL_LIGHT0, GL_POSITION, light0pos);
  glLightfv(GL_LIGHT1, GL_POSITION, light1pos);

  /* fr[ϊs̕ۑ */
  glPushMatrix();

  /* }`̉] */
  glRotatef((GLfloat)*r, 0.0f, 1.0f, 0.0f);

  /* }`̐F ()  */
  glMaterialfv(GL_FRONT_AND_BACK, GL_DIFFUSE, red);

  /* }`̕` */
  cube();

  /* fr[ϊs̕A */
  glPopMatrix();

  spGLSwapBuffers(component);

  /* ]p 0 ɖ߂ */
  if (++(*r) >= 360) *r = 0;
}

void resize(int w, int h)
{
  spDebug(10, "resize", "w = %d, h = %d\n", w, h);
  
  glViewport(0, 0, w, h);

  /* ϊs̐ݒ */
  glMatrixMode(GL_PROJECTION);
  glLoadIdentity();
  gluPerspective(30.0, (double)w / (double)h, 1.0, 100.0);

  /* fr[ϊs̐ݒ */
  glMatrixMode(GL_MODELVIEW);
  glLoadIdentity();
  gluLookAt(3.0, 4.0, 5.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0);
}

void init(void)
{
  glClearColor(1.0, 1.0, 1.0, 1.0);

  glEnable(GL_DEPTH_TEST);

  glEnable(GL_CULL_FACE);
  glCullFace(GL_FRONT);

  glEnable(GL_LIGHTING);
  glEnable(GL_LIGHT0);
  glEnable(GL_LIGHT1);
  glLightfv(GL_LIGHT1, GL_DIFFUSE, green);
  glLightfv(GL_LIGHT1, GL_SPECULAR, green);
  
  spDebug(10, "init", "done\n");
}

void canvas1CB(spComponent component, void *data)
{
  int *init_flag = (int *)data;
  spCallbackReason reason;
  int w = 0, h = 0;
  static int r = 0; /* ]p */
  
  reason = spGetCallbackReason(component);

  spDebug(10, "canvas1CB", "reason = %d\n", reason);
  
  spSetGLContext(component, context1);
  
  if (*init_flag == 0 || reason == SP_CR_RESIZE) {
    if (*init_flag == 0) {
      init();
      *init_flag = 1;
    }
    if (spGetSize(component, &w, &h) == SP_FALSE) return;
  
    spDebug(10, "canvas1CB", "w = %d, h = %d\n", w, h);
  
    resize(w, h);
    /*spGLSwapBuffers(component);*/
  }
  display(component, &r);
  
  spDebug(10, "canvas1CB", "done\n");
}

void canvas2CB(spComponent component, void *data)
{
  int *init_flag = (int *)data;
  spCallbackReason reason;
  int w = 0, h = 0;
  static int r = 0; /* ]p */
  
  reason = spGetCallbackReason(component);

  spDebug(10, "canvas2CB", "reason = %d\n", reason);
  
  spSetGLContext(component, context2);
  
  if (*init_flag == 0 || reason == SP_CR_RESIZE) {
    if (*init_flag == 0) {
      init();
      *init_flag = 1;
    }
    if (spGetSize(component, &w, &h) == SP_FALSE) return;
  
    spDebug(10, "canvas2CB", "w = %d, h = %d\n", w, h);
  
    resize(w, h);
    /*spGLSwapBuffers(component);*/
  }
  display(component, &r);
  
  spDebug(10, "canvas2CB", "done\n");
}

void mouse(spComponent component, void *data)
{
  /* R} (PXebvi߂) */
  spRefreshCanvas(component);
}

void keyboard(spComponent component, void *data)
{
  spKeySym code;
  
  if (spGetCallbackKeySym(component, &code) == SP_TRUE
      && code == SPK_Escape) {
    spQuit(0);
  }
}

static int canvas1_init = 0;
static int canvas2_init = 0;

int spMain(int argc, char *argv[])
{
  spTopLevel toplevel;
  spComponent window, canvas1, canvas2;
  spGLVisual visual;
  spGLAttribute attribs[] = { SP_GL_RGBA,
                              SP_GL_DOUBLEBUFFER,
                              SP_GL_DEPTH_SIZE, 1,
                              SP_GL_NONE };
  
  canvas1_init = 0;
  canvas2_init = 0;
  
  toplevel = spInitialize(&argc, &argv, NULL);

  visual = spCreateGLVisual(toplevel, attribs);

  window = spCreateMainFrame("Cube",
                             SppOrientation, SP_HORIZONTAL,
                             NULL);
  canvas1 = spCreateGLCanvas(window, "canvas1", visual, 300, 300,
                             SppPercentageWidth, 50,
                             SppCallbackFunc, canvas1CB,
                             SppCallbackData, &canvas1_init,
                             SppBorderOn, SP_TRUE,
                             SppSpacingOn, SP_TRUE,
                             NULL);
  spAddCallback(canvas1, SP_BUTTON_PRESS_CALLBACK | SP_BUTTON_RELEASE_CALLBACK,
                mouse, NULL);
  spAddCallback(canvas1, SP_KEY_PRESS_CALLBACK, keyboard, NULL);
  
  canvas2 = spCreateGLCanvas(window, "canvas2", visual, 300, 300,
                             SppPercentageWidth, 50,
                             SppCallbackFunc, canvas2CB,
                             SppCallbackData, &canvas2_init,
                             SppBorderOn, SP_TRUE,
                             SppSpacingOn, SP_TRUE,
                             NULL);
  spAddCallback(canvas2, SP_BUTTON_PRESS_CALLBACK | SP_BUTTON_RELEASE_CALLBACK,
                mouse, NULL);
  spAddCallback(canvas2, SP_KEY_PRESS_CALLBACK, keyboard, NULL);
  
  context1 = spCreateGLContext(canvas1, NULL);
  context2 = spCreateGLContext(canvas2, NULL);

  spPopupWindow(window);
  
  return spMainLoop(toplevel);
}
