/*
 * Version for spComponentEx  by Hideki Banno
 */
   
/*
 * Mesa 3-D graphics library
 * 
 * Copyright (C) 1999  Brian Paul   All Rights Reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * BRIAN PAUL BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
 * AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */


/*
 * Example of using glXUseXFont().
 * 5 November 1999
 * Brian Paul
 */


#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <sp/spComponentLib.h>
#include <sp/spGL.h>

#include <sp/spComponentMain.h>

#define JAPANESE_TEST
#define USE_SPGLSTRING
/*#undef USE_SPGLSTRING*/

#define USE_TEXTURE_FOR_GLSTRING

#if defined(JAPANESE_TEST) && defined(USE_SPGLSTRING)
#if defined(COCOA) || (defined(SP_SUPPORT_UTF8_STRING) && !defined(_WIN32) && !defined(TARGET_API_MAC_CARBON))
#include "strings_utf8jp.h"
#elif (defined(_WIN32) && !defined(__CYGWIN32__)) || defined(MACOS)
#include "strings_sjis.h"
#else
#include "strings_eucjp.h"
#endif
#else
#define TEST_STRING "This is a test string."
#endif

#if defined(MACOS) && !defined(COCOA)
/* non-Cocoa MacOS doesn't support texture-based spGLString */
#undef USE_TEXTURE_FOR_GLSTRING
#endif

static char *ProgramName = "xfont";

static char *FontName = "-*-*-*-*-*--48-*-*-*-*-*-*-*";
/*static char *FontName = "-*-*-medium-*-normal--64-*-*-*-*-*-*-*";*/
/*static char *FontName = "-*-Times-bold-i-normal--32-*-*-*-*-*-*-*";*/

#ifdef USE_SPGLSTRING
#include <sp/spGLString.h>

static spGLString glstring = NULL;
#else
static GLuint FontBase = 0;
#endif

static void setup_font( spComponent component );


static void resize( spComponent component, void *data )
{
   int width, height;

   spDebug(10, "resize", "in\n");
   
   if (spGetSize( component, &width, &height ) == SP_TRUE) {
      spDebug(10, "resize", "width = %d, height = %d\n", width, height);
      glViewport( 0, 0, width, height );
      glMatrixMode( GL_PROJECTION );
      glLoadIdentity();
      glOrtho( -1.0, 1.0, -1.0, 1.0, -1.0, 1.0 );
   }
   
   spDebug(10, "resize", "done\n");
}


static void redraw( spComponent component, void *data )
{
   static char *text = TEST_STRING;
   spBool *init_done = (spBool *)data;

   spDebug(10, "redraw", "in\n");

   if (spGetCallbackReason( component ) == SP_CR_RESIZE || *init_done == SP_FALSE) {
      if (*init_done == SP_FALSE) {
         glShadeModel( GL_FLAT );
         glClearColor( 0.5, 0.5, 1.0, 1.0 );
      }
   
      resize( component, NULL );
      *init_done = SP_TRUE;
      /*spGLSwapBuffers( component );*/
   }

   glClear( GL_COLOR_BUFFER_BIT );

   /* triangle */
   glColor3f( 0.2f, 0.2f, 1.0f );
   glBegin( GL_TRIANGLES );
   glVertex2f( 0.0f, 0.8f );
   glVertex2f( -0.8f, -0.7f );
   glVertex2f( 0.8f, -0.7f );
   glEnd();
   
   /* text */
   spDebug(10, "redraw", "draw text\n");
#ifdef USE_SPGLSTRING
   if (glstring != NULL) {
      spSetGLStringPos3f( glstring, -0.8f, -0.7f, 0.0f );
      spDrawGLString( component, glstring );
   }
#else
   /*glColor3f( 1.0f, 1.0f, 1.0f );*/
   glColor3f( 1.0f, 0.0f, 0.0f );
   glRasterPos2f( -0.8f, 0.0f ); 
   glListBase( FontBase );
   glCallLists( strlen(text), GL_UNSIGNED_BYTE, (GLubyte *) text );
#endif

   spGLSwapBuffers( component );
   
   spDebug(10, "redraw", "done\n");
}


static void keyPress( spComponent component, void *data )
{
   spKeySym code;
    
   if (spGetCallbackKeySym( component, &code ) == SP_TRUE) {
      spDebug(10, "keyPress", "code = %ld\n", (long)code);
      if (code == SPK_Escape) {
         /* escape */
         spQuit(0);
      }
   }
}


static void setup_font( spComponent component )
{
#ifdef USE_SPGLSTRING
   if (glstring != NULL) {
      spDestroyGLString( glstring );
   }
   glstring = spCreateGLString( component, TEST_STRING,
                                SppFontName, FontName,
                                SppForeground, /*"white"*/"red",
#if defined(USE_TEXTURE_FOR_GLSTRING)
                                SppGLStringUseTexture, SP_TRUE,
#endif
                                NULL);
   if (!glstring) {
      printf("Error: font %s not found\n", FontName);
      exit(0);
   }
#else
   FontBase = glGenLists((GLuint)255);
   if (!FontBase) {
      printf("Error: unable to allocate display lists\n");
      exit(0);
   }
   if (spGLUseFont( component, FontName, 0, 255, FontBase ) == SP_FALSE) {
      printf("Error: font %s not found\n", FontName);
      exit(0);
   }
#endif
}

static spBool init_done = SP_FALSE;

static spComponent make_rgb_db_window( spTopLevel toplevel, int width, int height )
{
   spGLAttribute attrib[] = { SP_GL_RGBA,
                              SP_GL_RED_SIZE, 1,
                              SP_GL_GREEN_SIZE, 1,
                              SP_GL_BLUE_SIZE, 1,
                              SP_GL_DOUBLEBUFFER,
                              SP_GL_NONE };
   spComponent win, canvas;
   spGLVisual visinfo;
   spGLContext ctx;

   init_done = SP_FALSE;
   
   visinfo = spCreateGLVisual( toplevel, attrib );
   if (!visinfo) {
      printf("Error: couldn't get an RGB, Double-buffered visual\n");
      exit(1);
   }

   win = spCreateMainFrame( ProgramName, NULL );
   canvas = spCreateGLCanvas( win, "canvas", visinfo, width, height,
                              SppCallbackFunc, redraw,
                              SppCallbackData, &init_done,
                              NULL );
   spAddCallback( canvas, SP_KEY_PRESS_CALLBACK, keyPress, NULL );
   
   ctx = spCreateGLContext( canvas, NULL );

   spPopupWindow( win );
   spDebug(10, "make_rgb_db_window", "spPopupWindow done\n");
   
   spSetGLContext( canvas, ctx );
   spDebug(10, "make_rgb_db_window", "spSetGLContext done\n");

   return canvas;
}


int spMain( int argc, char *argv[] )
{
   spTopLevel toplevel;
   spComponent canvas;

   /*spSetDebugLevel(30);*/

   /* initialize toolkit */
   toplevel = spInitialize( &argc, &argv, NULL );

   canvas = make_rgb_db_window( toplevel, 300, 300 );
   setup_font( canvas );

   return spMainLoop( toplevel );
}
