/*
 *	spGL.h
 */

#ifndef __SPGL_H
#define __SPGL_H

#if defined(_WIN32) && !(defined(USE_MOTIF) || defined(GTK))
#include <windows.h> 
#endif

#include <sp/spTopLevel.h>
#include <sp/spCanvas.h>
#include <sp/spDIBitmap.h>

#define GL_GLEXT_PROTOTYPES

#if defined(MACOS)
#if defined(IPHONE)
#if defined(USE_OPENGL_ES2)
#include <OpenGLES/ES2/gl.h> 
#include <OpenGLES/ES2/glext.h>
#endif
#include <OpenGLES/ES1/gl.h> 
#include <OpenGLES/ES1/glext.h>
#define SP_GL_ES 1
#elif defined(COCOA) /* defined(IPHONE) */
#define GL_SILENCE_DEPRECATION 1
#if defined(USE_OPENGL3)
#include <OpenGL/gl3.h>
#else
#include <OpenGL/gl.h> 
#endif
#include <OpenGL/glu.h>
#else /* defined(COCOA) */
#if TARGET_API_MAC_CARBON
#include <AGL/gl.h> 
#include <AGL/glu.h>
#else /* TARGET_API_MAC_CARBON */
#include <gl.h> 
#include <glu.h>
#endif /* !TARGET_API_MAC_CARBON */
#endif /* !defined(COCOA) */
#elif defined(ANDROID)
#include <EGL/egl.h>
#if defined(USE_OPENGL_ES3)
#include <GLES3/gl3.h>
#include <GLES3/gl3ext.h>
#elif defined(USE_OPENGL_ES2)
#include <GLES2/gl2.h>
#include <GLES2/gl2ext.h>
#endif /* defined(USE_OPENGL_ES2) */
#include <GLES/gl.h>
#include <GLES/glext.h>
#define SP_GL_ES 1
#else /* defined(ANDROID) */
#include <GL/gl.h> 
#include <GL/glu.h>
#endif /* !defined(ANDROID) */

#if defined(USE_MOTIF) || (defined(USE_GTK) && !defined(GTK3))
#include <X11/Xlib.h>
#include <GL/glx.h> 
#endif

#ifdef __cplusplus
extern "C" {
#endif

#define SP_GL_VERSION_STRING	"0.5.2"
#define SP_GL_VERSION 		0
#define SP_GL_REVISION		5
#define SP_GL_UPDATE_LEVEL	2
#define SP_GL_VERSION_ID	(SP_GL_VERSION * 1000 + SP_GL_REVISION)

#define SpGLCanvas "GLCanvas"
#define SpGLPixmap "GLPixmap"
#define SpGLString "GLString"

#define SppGLVisual "PGLVisual"		/* CG */

/* 0.5.0+ */
#define SppGLAutoScaling "bGLAutoScaling"	/* CG */
#define SppGLScalingFactor "dGLScalingFactor"	/* G */
#define SppGLStringUseTexture "bGLStringUseTexture"	/* CG */
#define SppGLStringUseShader "bGLStringUseShader"	/* CG */
#define SppGLStringProjectionMatrix "PGLStringProjectionMatrix"	/* CSG; must be a float column-measure matrix in array such as: GLfloat P[16]; */
#define SppGLStringModelViewMatrix "PGLStringModelViewMatrix"	/* CSG; must be a float column-measure matrix in array such as: GLfloat MV[16]; */
    
/* 0.5.1+ */
#define SppGLStringOptions "lGLStringOptions"	/* CG */

#if defined(GTK)
typedef int spGLAttribute;
#elif defined(COCOA)
typedef uint32_t spGLAttribute;
#elif defined(MACOS)
typedef GLint spGLAttribute;
#elif defined(ANDROID)
typedef GLint spGLAttribute;
#else
typedef int spGLAttribute;
#endif

#if defined(_WIN32) && !(defined(USE_MOTIF) || defined(GTK))
#define GLchar char
#define SPGLAPI WINAPI
#else
#if defined(MACOS9)
#define GLchar char
#endif
#define SPGLAPI
#endif
    
typedef struct _spGLVisual *spGLVisual;
typedef struct _spGLContext *spGLContext;
    
typedef struct _spGLCanvasRec *spGLCanvas;
typedef struct _spGLStringRec *spGLString;

/* 0.5.0+
 * This is struct for data exchange between host and GLSL.
 * This struct can be used as an array element on almost all environments,
 * for example:
 * spGLMat4 array[3];
 *   :
 * glUniformMatrix4fv(location, 3, GL_FALSE, (const GLfloat *)array);
 */
typedef struct _spGLMat4 {
    GLfloat data[4][4];
} spGLMat4;

#define SP_GL_NONE		  0
#define SP_GL_USE_GL              1       /* support GL rendering */
#define SP_GL_BUFFER_SIZE         2       /* depth of the color buffer */
#define SP_GL_LEVEL               3       /* level in plane stacking */
#define SP_GL_RGBA                4       /* true if RGBA mode */
#define SP_GL_DOUBLEBUFFER        5       /* double buffering supported */
#define SP_GL_STEREO              6       /* stereo buffering supported */
#define SP_GL_AUX_BUFFERS         7       /* number of aux buffers */
#define SP_GL_RED_SIZE            8       /* number of red component bits */
#define SP_GL_GREEN_SIZE          9       /* number of green component bits */
#define SP_GL_BLUE_SIZE           10      /* number of blue component bits */
#define SP_GL_ALPHA_SIZE          11      /* number of alpha component bits */
#define SP_GL_DEPTH_SIZE          12      /* number of depth bits */
#define SP_GL_STENCIL_SIZE        13      /* number of stencil bits */
#define SP_GL_ACCUM_RED_SIZE      14      /* number of red accum bits */
#define SP_GL_ACCUM_GREEN_SIZE    15      /* number of green accum bits */
#define SP_GL_ACCUM_BLUE_SIZE     16      /* number of blue accum bits */
#define SP_GL_ACCUM_ALPHA_SIZE    17      /* number of alpha accum bits */

/* 0.5.0+ */
#define SP_GL_TYPE_NONE                 0x8000
#define SP_GL_DONT_CARE                 0xFFFFFFFF
/* Windows only*/
#define SP_GL_NO_ACCELERATION           0x2025
#define SP_GL_GENERIC_ACCELERATION      0x2026
#define SP_GL_FULL_ACCELERATION         0x2027
#define SP_GL_ACCELERATION              0x2003    
/**/
#define SP_GL_NON_CONFORMANT_CONFIG     0x800D
#define SP_GL_SLOW_CONFIG               0x8001
#define SP_GL_CONFIG_CAVEAT		0x20
/**/    
#define SP_GL_CONTEXT_MAJOR_VERSION     0x2091
#define SP_GL_CONTEXT_MINOR_VERSION     0x2092
#define SP_GL_CONTEXT_DEBUG_BIT         0x00000001
#define SP_GL_CONTEXT_FORWARD_COMPATIBLE_BIT 0x00000002
#define SP_GL_CONTEXT_FLAGS             0x2094
#define SP_GL_CONTEXT_CORE_PROFILE_BIT  0x00000001
#define SP_GL_CONTEXT_COMPATIBILITY_PROFILE_BIT 0x00000002
#define SP_GL_CONTEXT_PROFILE_MASK      0x9126
/**/    
#if defined(_WIN32) && !(defined(USE_MOTIF) || defined(GTK))
#define SP_GL_PIXEL_TYPE_RGBA           0x202B
#define SP_GL_PIXEL_TYPE_COLOR_INDEX    0x202C
#define SP_GL_PIXEL_TYPE                0x2013
#else
#define SP_GL_PIXEL_TYPE_RGBA           0x00000001
#define SP_GL_PIXEL_TYPE_COLOR_INDEX    0x00000002
#define SP_GL_PIXEL_TYPE                0x8011
#endif
#if defined(ANDROID)
#define SP_GL_SAMPLE_BUFFERS            0x3032
#define SP_GL_SAMPLES                   0x3031
#elif defined(MACOS)
#define SP_GL_SAMPLE_BUFFERS            55
#define SP_GL_SAMPLES                   56
#elif defined(_WIN32) && !(defined(USE_MOTIF) || defined(GTK))
#define SP_GL_SAMPLE_BUFFERS            0x2041
#define SP_GL_SAMPLES                   0x2042
#elif defined(USE_MOTIF) || defined(GTK)
#define SP_GL_SAMPLE_BUFFERS            100000
#define SP_GL_SAMPLES                   100001
#else
#define SP_GL_SAMPLE_BUFFERS            0x80A8
#define SP_GL_SAMPLES                   0x80A9
#endif
    
#if defined(MACOS)
#pragma import on
#endif

extern spComponentClass SpGLCanvasClass;
extern spObjectClass SpGLStringClass;

extern spBool spIsGLCanvas(spComponent component);
extern spBool spIsGLDrawableComponent(spComponent component);
extern spBool spIsGLDrawable(spComponent component);
    
extern spGLVisual spCreateGLVisual(spTopLevel toplevel, spGLAttribute *attributes);
extern spBool spDestroyGLVisual(spGLVisual visual);
    
/* visual must exist while canvas exists. */
extern spComponent spCreateGLCanvas(spComponent parent, char *name, spGLVisual visual,
				    int canvas_width, int canvas_height, ...);
extern double spGetGLCanvasScalingFactor(spComponent component);
    
extern spGLContext spCreateGLContext(spComponent gldrawable, spGLContext share);
extern spBool spDestroyGLContext(spGLContext context);

/* spSetGLContext must be called after realization (such as spPopupWindow) */
extern spBool spSetGLContext(spComponent gldrawable, spGLContext context);
extern spGLContext spGetGLContext(spComponent gldrawable);

extern spBool spGLSwapBuffers(spComponent gldrawable);
/* spGLFlush calls spGLSwapBuffers (double buffer case)
   or glFlush (single buffer case) */
extern spBool spGLFlush(spComponent gldrawable); 
    
extern spBool spGLWaitGLDrawing(spComponent gldrawable);
extern spBool spGLWaitSystemDrawing(spComponent gldrawable);

/* 0.5.0+ */
extern GLint spGetGLDIBitmapUnpackAlignment(spDIBitmap dibitmap);
extern GLint spGetGLDIBitmapUnpackRowLength(spDIBitmap dibitmap);
extern spBool spGetGLDIBitmapFormat(spDIBitmap dibitmap, GLint *pinternal_format, GLenum *pformat, GLenum *ptype);
/* 0.5.2+ */
extern spBool spGetGLDIPixelFormatAlphaBlendFactor(spDIPixelFormat pixel_format, GLenum *psfactor, GLenum *pdfactor);
extern spBool spGetGLDIBitmapAlphaBlendFactor(spDIBitmap dibitmap, GLenum *sfactor, GLenum *dfactor);
    
/* 0.5.0+ */
extern spBool spIsGLExtensionIncludedInList(char *extList, char *extension);
extern spBool spIsGLExtensionSupported(GLenum name, char *extension);
extern char *spGetGLSystemExtensionList(spGLContext context);
extern void *spGetGLProcAddress(char *proc);
    
extern spBool spGLUseFont(spComponent gldrawable, char *font_name, int first, int count, int list_base);

/* 0.5.0+ */
extern spGLMat4 spGLMat4CreateIdentity(void);
extern spGLMat4 spGLMat4CreateZero(void);
extern spGLMat4 spGLMat4CreateRotation(GLfloat angleDegree, GLfloat x, GLfloat y, GLfloat z, spBool rowMajor);
extern spGLMat4 spGLMat4CreateScaling(GLfloat x, GLfloat y, GLfloat z);
extern spGLMat4 spGLMat4CreateTranslation(GLfloat x, GLfloat y, GLfloat z, spBool rowMajor);
extern spGLMat4 spGLMat4CreateOrtho(GLfloat left, GLfloat right, GLfloat bottom, GLfloat top,
				    GLfloat nearVal, GLfloat farVal, spBool rowMajor);
extern spGLMat4 spGLMat4CreateFrustum(GLfloat left, GLfloat right, GLfloat bottom, GLfloat top,
				      GLfloat nearVal, GLfloat farVal, spBool rowMajor);
extern spGLMat4 spGLMat4CreatePerspective(GLfloat fovyDegree, GLfloat aspect, GLfloat zNear, GLfloat zFar, spBool rowMajor);
extern spGLMat4 spGLMat4CreateLookAt(GLfloat eyeX, GLfloat eyeY, GLfloat eyeZ,
				     GLfloat centerX, GLfloat centerY, GLfloat centerZ,
				     GLfloat upX, GLfloat upY, GLfloat upZ, spBool rowMajor);
extern GLfloat spGLMat4LUDecomposition(spGLMat4 *A, GLint *index /* index[4] */);
extern spGLMat4 spGLMat4CreateInverse(spGLMat4 *A, spBool transpose);
extern spGLMat4 spGLMat4Createfv(GLfloat *data /* data[16] */, spBool transpose);
extern spGLMat4 spGLMat4CreateNormal(spGLMat4 *A, spBool transpose);
extern void spGLMat4Setfv(spGLMat4 *A, GLfloat *data /* data[16] */, spBool transpose);
extern void spGLMat4Getfv(spGLMat4 *A, GLfloat *data /* data[16] */, spBool transpose);
extern void spGLMat4SetRow4fv(spGLMat4 *A, GLint row, GLfloat *vec /* vec[4] */, spBool rowMajor);
extern void spGLMat4SetColumn4fv(spGLMat4 *A, GLint column, GLfloat *vec /* vec[4] */, spBool rowMajor);
extern void spGLMat4GetRow4fv(spGLMat4 *A, GLint row, GLfloat *vec /* vec[4] */, spBool rowMajor);
extern void spGLMat4GetColumn4fv(spGLMat4 *A, GLint column, GLfloat *vec /* vec[4] */, spBool rowMajor);
extern spGLMat4 spGLMat4Clone(spGLMat4 *A, spBool transpose);
extern void spGLMat4Copy(spGLMat4 *D, spGLMat4 *S, spBool transpose);
extern void spGLMat4ArrayToVec(GLfloat *dest, spGLMat4 *Ss, GLint n, spBool transpose);
extern void spGLMat4ArrayFromVec(spGLMat4 *Ds, GLfloat *src, GLint n, spBool transpose);
extern void spGLMat4Transpose(spGLMat4 *A);
extern spGLMat4 spGLMat4MultMatrix(spGLMat4 *A, spGLMat4 *B, spBool rowMajor);
extern spGLMat4 spGLMat4MultTransposeMatrix(spGLMat4 *A, spGLMat4 *Bt, spBool rowMajor);
extern void spGLMat4MultVector3fv(GLfloat *y /* y[3] */, spGLMat4 *A, GLfloat *x /* x[3] */, GLfloat xw, spBool rowMajor);
extern void spGLMat4MultVector4fv(GLfloat *y /* y[4] */, spGLMat4 *A, GLfloat *x /* x[4] */, spBool rowMajor);
extern void spGLMat4FDump(spGLMat4 *A, spBool transpose, FILE *fp);
extern void spGLMat4Dump(spGLMat4 *A, spBool transpose);
extern void spGLVecValuesfv(GLint n, GLfloat *a, GLfloat value);
extern void spGLVecZerofv(GLint n, GLfloat *a);
extern void spGLVecMultScalarfv(GLint n, GLfloat *a, GLfloat s);
extern void spGLVecAddfv(GLint n, GLfloat *c, GLfloat *a, GLfloat *b); /* c and a or b can have same address */
extern void spGLVecSubtractfv(GLint n, GLfloat *c, GLfloat *a, GLfloat *b); /* c and a or b can have same address */
extern GLfloat spGLVecDotfv(GLint n, GLfloat *a, GLfloat *b); /* a and b can have same address */
extern void spGLVecCross3fv(GLfloat *c /* c[3] */, GLfloat *a /* a[3] */, GLfloat *b /* b[3] */); /* c and a or b can have same address */
extern GLfloat spGLVecLengthfv(GLint n, GLfloat *a);
extern GLfloat spGLVecNormalizefv(GLint n, GLfloat *a);
    
#define spGLVecValues4fv(a, value) spGLVecValuesfv(4, a, value)
#define spGLVecZero4fv(a, value) spGLVecZerofv(4, a, value)
#define spGLVecMultScalar4fv(a, s) spGLVecMultScalarfv(4, a, s)
#define spGLVecAdd4fv(c, a, b) spGLVecAddfv(4, c, a, b)
#define spGLVecSubtract4fv(c, a, b) spGLVecSubtractfv(4, c, a, b)
#define spGLVecDot4fv(a, b) spGLVecDotfv(4, a, b)
#define spGLVecLength4fv(a) spGLVecLengthfv(4, a)
#define spGLVecNormalize4fv(a) spGLVecNormalizefv(4, a)

#define spGLVecValues3fv(a, value) spGLVecValuesfv(3, a, value)
#define spGLVecZero3fv(a, value) spGLVecZerofv(3, a, value)
#define spGLVecMultScalar3fv(a, s) spGLVecMultScalarfv(3, a, s)
#define spGLVecAdd3fv(c, a, b) spGLVecAddfv(3, c, a, b)
#define spGLVecSubtract3fv(c, a, b) spGLVecSubtractfv(3, c, a, b)
#define spGLVecDot3fv(a, b) spGLVecDotfv(3, a, b)
#define spGLVecLength3fv(a) spGLVecLengthfv(3, a)
#define spGLVecNormalize3fv(a) spGLVecNormalizefv(3, a)

#if !defined(GL_SAMPLE_BUFFERS)
#define GL_SAMPLE_BUFFERS 0x80A8
#endif
#if !defined(GL_SAMPLES)
#define GL_SAMPLES 0x80A9
#endif
#if !defined(GL_MULTISAMPLE)
#define GL_MULTISAMPLE 0x809D
#endif
#if !defined(GL_UNPACK_ROW_LENGTH)
#define GL_UNPACK_ROW_LENGTH 0x0CF2
#endif

#if defined(SP_GL_ES)
#define GLdouble GLfloat
#define GL_QUADS ((GL_TRIANGLE_FAN)+1)
#define GL_QUAD_STRIP ((GL_TRIANGLE_FAN)+2)
#define GL_POLYGON ((GL_TRIANGLE_FAN)+3)
    
extern void glBegin(GLenum mode);
extern void glVertex3f(GLfloat x, GLfloat y, GLfloat z);
extern void glVertex3fv(GLfloat *v);
extern void glVertex2f(GLfloat x, GLfloat y);
extern void glVertex2fv(GLfloat *v);
extern void spGLNormal3f(GLfloat nx, GLfloat ny, GLfloat nz);
extern void spGLNormal3fv(GLfloat *v);
extern void glEnd(void);
extern void glColor4fv(GLfloat *v);
    
#define glNormal3f spGLNormal3f
#define glNormal3fv spGLNormal3fv
#define glNormal3d spGLNormal3f
#define glNormal3dv spGLNormal3fv
#define glVertex3d glVertex3f
#define glVertex3dv glVertex3fv
#define glOrtho glOrthof
#define glRotated glRotatef
#define glTranslated glTranslatef
#define glScaled glScalef

#define glColor3f(r,g,b) glColor4f(r,g,b,1.0f)
    
extern void gluPerspective(GLfloat fovyDegree, GLfloat aspect, GLfloat zNear, GLfloat zFar);
extern void gluLookAt(GLfloat eyex, GLfloat eyey, GLfloat eyez,
		      GLfloat centerx, GLfloat centery, GLfloat centerz,
		      GLfloat upx, GLfloat upy, GLfloat upz);
    
#endif
    
#if defined(MACOS)
#pragma import off
#endif

#ifdef __cplusplus
}  /* Close scope of 'extern "C"' declaration */
#endif

#endif /* __SPGL_H */
