/*
 *	spGLP.h
 */

#ifndef __SPGLP_H
#define __SPGLP_H

#include <sp/spDIBitmap.h>
#include <sp/spCanvasP.h>
#include <sp/spGL.h>

#if defined(GTK)
#include <sp/spGL_Gtk.h>
#elif defined(_WIN32) && !defined(USE_MOTIF)
#include <sp/spGL_Win.h>
#elif defined(ANDROID)
#include <sp/spGL_Egl.h>
#elif defined(COCOA)
#include <sp/spGL_Cocoa.h>
#elif defined(MACOS)
#include <sp/spGL_Mac.h>
#else
#include <sp/spGL_Xm.h>
#endif

#ifdef __cplusplus
extern "C" {
#endif

struct _spGLVisual {
    spGLVisualArchPart arch_part;
};
    
struct _spGLContext {
    spGLContextArchPart arch_part;
};
    
#define SP_GL_ATTRIBUTE_TYPE_CORE_MASK (1L)
#define SP_GL_ATTRIBUTE_TYPE_CONTEXT_MASK (1L<<1)

typedef struct _spGLAttributeSupportInfo {
    spGLAttribute attribute;
    int min_version_id;
    int max_version_id;
    int legacy_num_param;
    spBool legacy_only;
    unsigned long type_mask;
} spGLAttributeSupportInfo;

typedef struct _spGLCanvasPart {
#if defined(SP_GL_CANVAS_HAS_ARCH_PART)
    spGLCanvasArchPart arch_part;
#endif
    spGLVisual glvisual;
    spGLContext current_context;

    spBool auto_scaling;
    double scaling_factor;
} spGLCanvasPart;

typedef struct _spGLCanvasRec {
    spObjectPart object;
    spComponentPart component;
    spPrimitivePart primitive;
    spCanvasPart canvas;
    spGLCanvasPart glcanvas;
} spGLCanvasRec;
    
typedef struct _spGLCanvasClassPart {
    int dummy;
} spGLCanvasClassPart;

typedef struct _spGLCanvasClassRec {
    spObjectClassPart object;
    spComponentClassPart component;
    spPrimitiveClassPart primitive;
    spCanvasClassPart canvas;
    spGLCanvasClassPart glcanvas;
} spGLCanvasClassRec;

#if defined(MACOS)
#pragma import on
#endif

extern spGLCanvasClassRec SpGLCanvasClassRec;
    
#define SpGLCanvasPart(comp) (((spGLCanvas)comp)->glcanvas)
#if defined(SP_GL_CANVAS_HAS_ARCH_PART)
#define SpGLCanvasArch(comp) (((spGLCanvas)(comp))->glcanvas.arch_part)
#endif
#define SpParentGLCanvasPart(comp) (((spGLCanvas)SpGetParent(comp))->glcanvas)
#define SpGetGLCanvasClass(comp) ((spGLCanvasClass)((comp)->object.object_class))

#define SpGLVisualArch(obj) (((spGLVisual)obj)->arch_part)
#define SpGLContextArch(obj) (((spGLContext)obj)->arch_part)
    
extern void spGLCanvasPartInit(spObject object);
extern void spGLCanvasPartFree(spObject object);
extern spBool spGLCanvasCreate(spObject object);
extern spBool spGLCanvasCreateArch(spComponent component);
extern spBool spGLCanvasSetParams(spObject object);
extern spBool spGLCanvasSetParamsArch(spComponent component);
extern spBool spGLCanvasDestroy(spObject object);
extern spBool spGLCanvasDestroyArch(spComponent component);

extern spBool spGLCanvasRefresh(spComponent component);
extern spBool spGLCanvasRedraw(spComponent component);
extern spBool spGLCanvasRedrawArch(spComponent component);
extern spBool spGLCanvasPostRedrawArch(spComponent component);
extern spBool spGetGLCanvasScalingFactorArch(spComponent component);

extern spBool spCreateGLVisualArch(spGLVisual visual, spTopLevel toplevel, spGLAttribute *attributes);
extern spBool spDestroyGLVisualArch(spGLVisual visual);
    
extern int spNumGLAttributeParams(spGLAttribute attribute);
extern spGLAttribute *xspExtractGLAttributes(spGLAttribute *attributes, int version_id, spBool legacy_flag, unsigned long type_mask, int *o_count);
extern spBool spGetVersionFromGLAttributes(spGLAttribute *attributes, int *major, int *minor);

extern spBool spCreateGLContextArch(spGLContext context, spComponent gldrawable, spGLVisual visual, spGLContext share);
extern spBool spDestroyGLContextArch(spGLContext context);

extern spBool spSetGLContextArch(spComponent gldrawable, spGLContext context);
extern spBool spGLSwapBuffersArch(spComponent gldrawable);

extern spBool spGLWaitGLDrawingArch(spComponent gldrawable);
extern spBool spGLWaitSystemDrawingArch(spComponent gldrawable);
extern spBool spGLUseFontArch(spComponent gldrawable, char *font_name, int first, int count, int list_base);

#if !(defined(_WIN32) || defined(XmVersion) || defined(GTK))
extern char *spGetGLSystemExtensionListArch(spGLContext context);
extern void *spGetGLProcAddressArch(char *proc);
#endif
    
#if defined(MACOS)
#pragma import off
#endif
    
#ifdef __cplusplus
}  /* Close scope of 'extern "C"' declaration */
#endif

#endif /* __SPGLP_H */
