/*
 *	spGLPhongModel.h
 */

#ifndef __SPGLPHONGMODEL_H
#define __SPGLPHONGMODEL_H

#include <sp/spGL.h>

#ifdef __cplusplus
extern "C" {
#endif

#define SP_GL_PHONG_MODEL_VERSION_STRING	"0.2.0"
#define SP_GL_PHONG_MODEL_VERSION 	0
#define SP_GL_PHONG_MODEL_REVISION	2
#define SP_GL_PHONG_MODEL_UPDATE_LEVEL	0
#define SP_GL_PHONG_MODEL_VERSION_ID	(SP_GL_PHONG_MODEL_VERSION * 1000 + SP_GL_PHONG_MODEL_REVISION)

/* Options are compatible with spGLString */
#define SP_GL_PHONG_MODEL_SHADER_VERSION_MASK 0x7fff
#define SP_GL_PHONG_MODEL_SHADER_VERSION_ES 0x8000

#define SP_GL_PHONG_MODEL_SHADER_VERSION_GLES_2_0 (0x8000|100)
#define SP_GL_PHONG_MODEL_SHADER_VERSION_GLES_3_0 (0x8000|300)
#define SP_GL_PHONG_MODEL_SHADER_VERSION_GLES_3_1 (0x8000|310)
#define SP_GL_PHONG_MODEL_SHADER_VERSION_GLES_3_2 (0x8000|320)
#define SP_GL_PHONG_MODEL_SHADER_VERSION_GL_2_0 (0)
#define SP_GL_PHONG_MODEL_SHADER_VERSION_GL_2_1 (120)
#define SP_GL_PHONG_MODEL_SHADER_VERSION_GL_3_0 (130)
#define SP_GL_PHONG_MODEL_SHADER_VERSION_GL_3_1 (140)
#define SP_GL_PHONG_MODEL_SHADER_VERSION_GL_3_2 (150)
#define SP_GL_PHONG_MODEL_SHADER_VERSION_GL_3_3 (330)
#define SP_GL_PHONG_MODEL_SHADER_VERSION_GL_4_0 (400)
#define SP_GL_PHONG_MODEL_SHADER_VERSION_GL_4_1 (410)
#define SP_GL_PHONG_MODEL_SHADER_VERSION_GL_4_2 (420)
#define SP_GL_PHONG_MODEL_SHADER_VERSION_GL_4_3 (430)
#define SP_GL_PHONG_MODEL_SHADER_VERSION_GL_4_4 (440)
#define SP_GL_PHONG_MODEL_SHADER_VERSION_GL_4_5 (450)

#define SP_GL_PHONG_MODEL_OPTION_NONE 0L
#define SP_GL_PHONG_MODEL_OPTION_USE_SHADER (1L<<17)
#define SP_GL_PHONG_MODEL_OPTION_USE_VAO (1L<<18) /* This option is currently invalidated, left for compatibility. Use draw_mode of spGLPhongModelBegin */
#define SP_GL_PHONG_MODEL_OPTION_USE_LEGACY_FUNCTION (1L<<19)
#define SP_GL_PHONG_MODEL_OPTION_USE_PHONG_SHADING (1L<<20)
#define SP_GL_PHONG_MODEL_OPTION_USE_FLAT_SHADING (1L<<21) /* OpenGL 3.2+ only */
#define SP_GL_PHONG_MODEL_OPTION_USE_HALFWAY_VECTOR (1L<<22)
#define SP_GL_PHONG_MODEL_OPTION_USE_CLIP_PLANE (1L<<23)

#define SP_GL_STREAM_DRAW 0x88E0
#define SP_GL_STREAM_READ 0x88E1
#define SP_GL_STREAM_COPY 0x88E2
#define SP_GL_STATIC_DRAW 0x88E4
#define SP_GL_STATIC_READ 0x88E5
#define SP_GL_STATIC_COPY 0x88E6
#define SP_GL_DYNAMIC_DRAW 0x88E8
#define SP_GL_DYNAMIC_READ 0x88E9
#define SP_GL_DYNAMIC_COPY 0x88EA

typedef enum {
    SP_GL_PHONG_MODEL_DRAW_MODE_DIRECT = 0,
    SP_GL_PHONG_MODEL_DRAW_MODE_USE_VBO = 1,
    SP_GL_PHONG_MODEL_DRAW_MODE_USE_VAO = 2,
} spGLPhongModelDrawMode;

typedef struct _spGLPhongModel *spGLPhongModel;

#if defined(MACOS)
#pragma import on
#endif

extern spGLPhongModel spGLPhongModelInit(int light_count, unsigned long options);
extern spBool spGLPhongModelFree(spGLPhongModel glpm);

extern spBool spGLPhongModelSetProjectionMatrix(spGLPhongModel glpm, spGLMat4 *P);
extern spBool spGLPhongModelGetProjectionMatrix(spGLPhongModel glpm, spGLMat4 *P);
extern spBool spGLPhongModelSetModelViewMatrix(spGLPhongModel glpm, spGLMat4 *MV);
extern spBool spGLPhongModelGetModelViewMatrix(spGLPhongModel glpm, spGLMat4 *MV);
extern spBool spGLPhongModelUpdateTransformationMatrix(spGLPhongModel glpm);

extern spBool spGLPhongModelSetMaterialMatrix(spGLPhongModel glpm, spGLMat4 *material);
extern spBool spGLPhongModelGetMaterialMatrix(spGLPhongModel glpm, spGLMat4 *material);
extern spBool spGLPhongModelUpdateMaterialMatrix(spGLPhongModel glpm);

/* shader version only */
extern spBool spGLPhongModelSetFrontMixColor(spGLPhongModel glpm, GLfloat rate, GLfloat *color);
extern spBool spGLPhongModelGetFrontMixColor(spGLPhongModel glpm, GLfloat *rate, GLfloat *color);
extern spBool spGLPhongModelSetBackMixColor(spGLPhongModel glpm, GLfloat rate, GLfloat *color);
extern spBool spGLPhongModelGetBackMixColor(spGLPhongModel glpm, GLfloat *rate, GLfloat *color);
extern spBool spGLPhongModelUpdateMixColor(spGLPhongModel glpm);
    
extern spBool spGLPhongModelSetLightPosition(spGLPhongModel glpm, int index, GLfloat *position);
extern spBool spGLPhongModelGetLightPosition(spGLPhongModel glpm, int index, GLfloat *position);
extern spBool spGLPhongModelSetLightAmbient(spGLPhongModel glpm, int index, GLfloat *ambient);
extern spBool spGLPhongModelGetLightAmbient(spGLPhongModel glpm, int index, GLfloat *ambient);
extern spBool spGLPhongModelSetLightDiffuse(spGLPhongModel glpm, int index, GLfloat *diffuse);
extern spBool spGLPhongModelGetLightDiffuse(spGLPhongModel glpm, int index, GLfloat *diffuse);
extern spBool spGLPhongModelSetLightSpecular(spGLPhongModel glpm, int index, GLfloat *specular);
extern spBool spGLPhongModelGetLightSpecular(spGLPhongModel glpm, int index, GLfloat *specular);
extern spBool spGLPhongModelSetLightAttenuation(spGLPhongModel glpm, int index, GLfloat *attenuation);
extern spBool spGLPhongModelGetLightAttenuation(spGLPhongModel glpm, int index, GLfloat *attenuation);
extern spBool spGLPhongModelSetLightSpotCutoff(spGLPhongModel glpm, int index, GLfloat cutoff);
extern spBool spGLPhongModelGetLightSpotCutoff(spGLPhongModel glpm, int index, GLfloat *cutoff);
extern spBool spGLPhongModelSetLightSpotExponent(spGLPhongModel glpm, int index, GLfloat exponent);
extern spBool spGLPhongModelGetLightSpotExponent(spGLPhongModel glpm, int index, GLfloat *exponent);
extern spBool spGLPhongModelSetLightSpotDirection(spGLPhongModel glpm, int index, GLfloat *direction);
extern spBool spGLPhongModelGetLightSpotDirection(spGLPhongModel glpm, int index, GLfloat *direction);
extern spBool spGLPhongModelUpdateLight(spGLPhongModel glpm, int index);

extern spBool spGLPhongModelSetClipPlane(spGLPhongModel glpm, int index, GLfloat *equation);
extern spBool spGLPhongModelUnsetClipPlane(spGLPhongModel glpm, int index);
extern spBool spGLPhongModelGetClipPlane(spGLPhongModel glpm, int index, GLfloat *equation);
extern spBool spGLPhongModelUpdateClipPlane(spGLPhongModel glpm);

extern spBool spGLPhongModelBegin(spGLPhongModel glpm, spGLPhongModelDrawMode draw_mode);
extern spBool spGLPhongModelEnd(spGLPhongModel glpm);
extern spBool spGLPhongModelVertexPointer(spGLPhongModel glpm, GLenum type, GLsizei stride, const GLfloat *pointer);
extern spBool spGLPhongModelNormalPointer(spGLPhongModel glpm, GLenum type, GLsizei stride, const GLfloat *pointer);
extern spBool spGLPhongModelDrawArrays(spGLPhongModel glpm, GLenum mode, GLint first, GLsizei count);
extern spBool spGLPhongModelDrawElements(spGLPhongModel glpm, GLenum mode, GLsizei count, GLenum type, const GLvoid *indices);

extern spBool spGLPhongModelGenBuffers(spGLPhongModel glpm, GLsizei n, GLuint *buffers);
extern spBool spGLPhongModelDeleteBuffers(spGLPhongModel glpm, GLsizei n, GLuint *buffers);
extern spBool spGLPhongModelBindVertexOrNormalBuffer(spGLPhongModel glpm, GLuint buffer);
extern spBool spGLPhongModelVertexOrNormalBufferData(spGLPhongModel glpm, /*GLsizeiptr*/size_t size,
                                                     const GLvoid * data, GLenum usage);
extern spBool spGLPhongModelVertexOrNormalBufferSubData(spGLPhongModel glpm, /*GLintptr*/size_t offset,
                                                        /*GLsizeiptr*/size_t size, const GLvoid * data);
extern spBool spGLPhongModelBindIndexBuffer(spGLPhongModel glpm, GLuint buffer);
extern spBool spGLPhongModelIndexBufferData(spGLPhongModel glpm, /*GLsizeiptr*/size_t size,
                                            const GLvoid * data, GLenum usage);
extern spBool spGLPhongModelIndexBufferSubData(spGLPhongModel glpm, /*GLintptr*/size_t offset,
                                               /*GLsizeiptr*/size_t size, const GLvoid * data);

/* for VAO */
extern spBool spGLPhongModelGenVertexArrays(spGLPhongModel glpm, GLsizei n, GLuint *arrays);
extern spBool spGLPhongModelDeleteVertexArrays(spGLPhongModel glpm, GLsizei n, GLuint *arrays);
extern spBool spGLPhongModelBindVertexArray(spGLPhongModel glpm, GLuint array);
extern spBool spGLPhongModelEnableVertexArray(spGLPhongModel glpm);
extern spBool spGLPhongModelDisableVertexArray(spGLPhongModel glpm);
extern spBool spGLPhongModelEnableNormalArray(spGLPhongModel glpm);
extern spBool spGLPhongModelDisableNormalArray(spGLPhongModel glpm);

#if defined(MACOS)
#pragma import off
#endif
    
#ifdef __cplusplus
}  /* Close scope of 'extern "C"' declaration */
#endif

#endif /* __SPGLPHONGMODEL_H */
