/*
 *	spGLShader.h
 *
 *	If you want to use glew, this file must be included after glew.h
 */

#ifndef __SPGLSHADER_H
#define __SPGLSHADER_H

#include <stdarg.h>

#include <sp/spGL.h>

#ifdef __cplusplus
extern "C" {
#endif
    
#if !defined(GL_MAX_TEXTURE_UNITS)
#define GL_MAX_TEXTURE_UNITS 0x84E2
#endif
#if !defined(GL_TEXTURE0)
#define GL_TEXTURE0 0x84C0
#endif

#if !defined(GL_FRAGMENT_SHADER)
#define GL_FRAGMENT_SHADER                0x8B30
#endif
#if !defined(GL_VERTEX_SHADER)
#define GL_VERTEX_SHADER                  0x8B31
#endif
#if !defined(GL_COMPILE_STATUS)
#define GL_COMPILE_STATUS                 0x8B81
#endif
#if !defined(GL_LINK_STATUS)
#define GL_LINK_STATUS                    0x8B82
#endif
#if !defined(GL_INFO_LOG_LENGTH)
#define GL_INFO_LOG_LENGTH                0x8B84
#endif
#if !defined(GL_CURRENT_PROGRAM)
#define GL_CURRENT_PROGRAM                0x8B8D
#endif

#if !defined(GL_ARRAY_BUFFER)
#define GL_ARRAY_BUFFER                   0x8892
#endif
#if !defined(GL_STATIC_DRAW)
#define GL_STATIC_DRAW                    0x88E4
#endif

#if !defined(GL_SHADING_LANGUAGE_VERSION)
#define GL_SHADING_LANGUAGE_VERSION       0x8B8C
#endif

#define SP_GL_SHADER_GET_VERSION_OPTION_NONE 0L
#define SP_GL_SHADER_GET_VERSION_OPTION_WITH_MODERN_API (1L)
#define SP_GL_SHADER_GET_VERSION_OPTION_WITH_LEGACY_API (1L<<1)

#define SP_GL_SHADER_GET_PREFIX_OPTION_NONE 0L
#define SP_GL_SHADER_GET_PREFIX_OPTION_USE_FRAG_DATA (1L) /* use gl_FragData instead of gl_FragColor */
#define SP_GL_SHADER_GET_PREFIX_OPTION_USE_LEGACY_FRAGMENT_OUTPUT (1L<<1) /* use gl_FragColor or gl_FragData */
#define SP_GL_SHADER_GET_PREFIX_OPTION_NO_DEFAULT_PRECISION (1L<<2) /* if you don't need precision line */

#if defined(IPHONE)
#define SP_GL_CLIP_PLANE_SUPPORTED_SHADER_VERSION 100
#elif defined(ANDROID)
#define SP_GL_CLIP_PLANE_SUPPORTED_SHADER_VERSION 400
#else
#define SP_GL_CLIP_PLANE_SUPPORTED_SHADER_VERSION 130
#endif

#if defined(MACOS)
#pragma import on
#endif

#if !defined(GLEW_GET_FUN) && (defined(_WIN32) && !(defined(USE_MOTIF) || defined(GTK)))
#define SP_GL_INTERNAL_FUNCTION_NAME(name) sp_ ## name 
#else
#define SP_GL_INTERNAL_FUNCTION_NAME(name) name
#endif

extern spBool spGLShaderGetVersion(unsigned long options, unsigned long *min_version, unsigned long *max_version, spBool *es_flag);

/*
 * Including the following macros (LEGACY <--> MODERN): 
 * vertex shader:
 *   attribute <--> in
 *   varying <--> out
 *   "" <-- flat
 * fragment shader:
 *   varying <--> in
 *   "" <-- flat
 *   gl_FragColor <--> FragColor (~SP_GL_SHADER_GET_PREFIX_OPTION_USE_FRAG_DATA)
 *   gl_FragData <--> FragData (SP_GL_SHADER_GET_PREFIX_OPTION_USE_FRAG_DATA)
 */
extern GLchar *xspGLShaderGetPrefix(GLenum shader_type, unsigned long options, unsigned long version, unsigned long source_version, spBool es_flag);

extern GLchar *_xspGLShaderGetShaderInfoLog(void (SPGLAPI *getShaderivProc)(GLuint, GLenum, GLint *),
                                            void (SPGLAPI *getShaderInfoLogProc)(GLuint, GLsizei, GLsizei *, GLchar *),
                                            GLuint shader);
#define xspGLShaderGetShaderInfoLog(shader) _xspGLShaderGetShaderInfoLog(SP_GL_INTERNAL_FUNCTION_NAME(glGetShaderiv), SP_GL_INTERNAL_FUNCTION_NAME(glGetShaderInfoLog), shader)

extern GLchar *_xspGLShaderGetProgramInfoLog(void (SPGLAPI *getProgramivProc)(GLuint, GLenum, GLint *),
                                             void (SPGLAPI *getProgramInfoLogProc)(GLuint, GLsizei, GLsizei *, GLchar *),
                                             GLuint program);
#define xspGLShaderGetProgramInfoLog(program) _xspGLShaderGetProgramInfoLog(SP_GL_INTERNAL_FUNCTION_NAME(glGetProgramiv), SP_GL_INTERNAL_FUNCTION_NAME(glGetProgramInfoLog), program)

extern GLint _spGLShaderCheckCompileError(void (SPGLAPI *getShaderivProc)(GLuint, GLenum, GLint *),
                                          void (SPGLAPI *getShaderInfoLogProc)(GLuint, GLsizei, GLsizei *, GLchar *),
                                          GLuint shader);
#define spGLShaderCheckCompileError(shader) _spGLShaderCheckCompileError(SP_GL_INTERNAL_FUNCTION_NAME(glGetShaderiv), SP_GL_INTERNAL_FUNCTION_NAME(glGetShaderInfoLog), shader)

extern GLint _spGLShaderCheckLinkError(void (SPGLAPI *getProgramivProc)(GLuint, GLenum, GLint *),
                                       void (SPGLAPI *getProgramInfoLogProc)(GLuint, GLsizei, GLsizei *, GLchar *),
                                       GLuint program);
#define spGLShaderCheckLinkError(program) _spGLShaderCheckLinkError(SP_GL_INTERNAL_FUNCTION_NAME(glGetProgramiv), SP_GL_INTERNAL_FUNCTION_NAME(glGetProgramInfoLog), program)

extern GLuint _spGLShaderCompile(GLuint (SPGLAPI *createShaderProc)(GLenum),
                                 void (SPGLAPI *shaderSourceProc)(GLuint, GLsizei, const GLchar * const*, const GLint *),
                                 void (SPGLAPI *compileShaderProc)(GLuint),
                                 void (SPGLAPI *getShaderivProc)(GLuint, GLenum, GLint *),
                                 void (SPGLAPI *getGetShaderInfoLogProc)(GLuint, GLsizei, GLsizei *, GLchar *),
                                 GLenum shader_type, const GLchar *source);
#define spGLShaderCompile(shader_type, source) _spGLShaderCompile(SP_GL_INTERNAL_FUNCTION_NAME(glCreateShader), SP_GL_INTERNAL_FUNCTION_NAME(glShaderSource), SP_GL_INTERNAL_FUNCTION_NAME(glCompileShader), SP_GL_INTERNAL_FUNCTION_NAME(glGetShaderiv), SP_GL_INTERNAL_FUNCTION_NAME(glGetShaderInfoLog), shader_type, source)

extern GLuint _spGLShaderCompileAndAttach(GLuint (SPGLAPI *createShaderProc)(GLenum),
                                          void (SPGLAPI *shaderSourceProc)(GLuint, GLsizei, const GLchar * const*, const GLint *),
                                          void (SPGLAPI *compileShaderProc)(GLuint),
                                          void (SPGLAPI *attachShaderProc)(GLuint, GLuint),
                                          void (SPGLAPI *getShaderivProc)(GLuint, GLenum, GLint *),
                                          void (SPGLAPI *getShaderInfoLogProc)(GLuint, GLsizei, GLsizei *, GLchar *),
                                          GLuint program, GLenum shader_type, const GLchar *source);
#define spGLShaderCompileAndAttach(program, shader_type, source) _spGLShaderCompileAndAttach(SP_GL_INTERNAL_FUNCTION_NAME(glCreateShader), SP_GL_INTERNAL_FUNCTION_NAME(glShaderSource), SP_GL_INTERNAL_FUNCTION_NAME(glCompileShader), SP_GL_INTERNAL_FUNCTION_NAME(glAttachShader), SP_GL_INTERNAL_FUNCTION_NAME(glGetShaderiv), SP_GL_INTERNAL_FUNCTION_NAME(glGetShaderInfoLog), program, shader_type, source)

#if defined(MACOS)
#pragma import off
#endif
    
#ifdef __cplusplus
}  /* Close scope of 'extern "C"' declaration */
#endif

#endif /* __SPGLSHADER_H */
