/*
 *	spGLShader_Win.h
 */

#ifndef __SPGLSHADER_WIN_H
#define __SPGLSHADER_WIN_H

#include <windows.h>

#ifdef __cplusplus
extern "C" {
#endif

#define SP_GL_TEXTURE_SUPPORTED
#define SP_GL_SHADER_SUPPORTED

#define SP_WGL_DECLARE_FUNCTION(name) sp_ ## name ## Proc sp_ ## name ;
#define SP_WGL_DECLARE_EXTERN_FUNCTION(name) extern sp_ ## name ## Proc sp_ ## name ;
#define SP_WGL_LOAD_EXT_FUNCTION(name) (sp_ ## name = (sp_ ## name ## Proc)wglGetProcAddress( #name ))
#define spIsWGLFunctionLoaded(name) ((sp_ ## name != NULL) ? SP_TRUE : SP_FALSE)

typedef BOOL (WINAPI *sp_wglChoosePixelFormatARBProc)(HDC, const int *, const FLOAT *, UINT, int *, UINT *);    
typedef HGLRC (WINAPI *sp_wglCreateContextAttribsARBProc)(HDC, HGLRC, const int *);
typedef const char *(WINAPI *sp_wglGetExtensionsStringARBProc)(HDC);
typedef const char *(WINAPI *sp_wglGetExtensionsStringEXTProc)(void);
    
typedef void (WINAPI *sp_glActiveTextureProc)(GLenum);
#define glActiveTexture(texture) sp_glActiveTexture(texture)
typedef void (WINAPI *sp_glClientActiveTextureProc)(GLenum);
#define glClientActiveTexture(texture) sp_glClientActiveTexture(texture)

typedef void (WINAPI *sp_glGetProgramivProc)(GLuint, GLenum, GLint *);
#define glGetProgramiv(program, pname, params) sp_glGetProgramiv(program, pname, params)
typedef void (WINAPI *sp_glGetProgramInfoLogProc)(GLuint, GLsizei, GLsizei *, GLchar *);
#define glGetProgramInfoLog(program, bufSize, length, infoLog) sp_glGetProgramInfoLog(program, bufSize, length, infoLog)
typedef void (WINAPI *sp_glGetShaderivProc)(GLuint, GLenum, GLint *);
#define glGetShaderiv(shader, pname, params) sp_glGetShaderiv(shader, pname, params)
typedef void (WINAPI *sp_glGetShaderInfoLogProc)(GLuint, GLsizei, GLsizei *, GLchar *);
#define glGetShaderInfoLog(shader, bufSize, length, infoLog) sp_glGetShaderInfoLog(shader, bufSize, length, infoLog)

typedef void (WINAPI *sp_glAttachShaderProc)(GLuint, GLuint);
#define glAttachShader(program, shader) sp_glAttachShader(program, shader)
typedef void (WINAPI *sp_glDetachShaderProc)(GLuint, GLuint);
#define glDetachShader(program, shader) sp_glDetachShader(program, shader)
typedef GLuint (WINAPI *sp_glCreateProgramProc)(void);
#define glCreateProgram() sp_glCreateProgram()
typedef void (WINAPI *sp_glDeleteProgramProc)(GLuint);
#define glDeleteProgram(program) sp_glDeleteProgram(program)
typedef GLuint (WINAPI *sp_glCreateShaderProc)(GLenum);
#define glCreateShader(type) sp_glCreateShader(type)
typedef void (WINAPI *sp_glDeleteShaderProc)(GLuint);
#define glDeleteShader(shader) sp_glDeleteShader(shader)
typedef void (WINAPI *sp_glCompileShaderProc)(GLuint);
#define glCompileShader(shader) sp_glCompileShader(shader)
    
typedef GLboolean (WINAPI *sp_glIsProgramProc)(GLuint);
#define glIsProgram(program) sp_glIsProgram(program)
typedef GLboolean (WINAPI *sp_glIsShaderProc)(GLuint);
#define glIsShader(shader) sp_glIsShader(shader)
typedef void (WINAPI *sp_glLinkProgramProc)(GLuint);
#define glLinkProgram(program) sp_glLinkProgram(program)
typedef void (WINAPI *sp_glUseProgramProc)(GLuint program);
#define glUseProgram(program) sp_glUseProgram(program)
typedef void (WINAPI *sp_glShaderSourceProc)(GLuint, GLsizei, const GLchar **, const GLint *);
#define glShaderSource(shader, count, string, length) sp_glShaderSource(shader, count, string, length)
typedef void (WINAPI *sp_glGetShaderSourceProc)(GLuint, GLsizei, GLsizei *, GLchar *);
#define glGetShaderSource(shader, bufSize, length, source) sp_glGetShaderSource(shader, bufSize, length, source)

typedef GLint (WINAPI *sp_glGetAttribLocationProc)(GLuint, const GLchar *);
#define glGetAttribLocation(program, name) sp_glGetAttribLocation(program, name)
typedef GLint (WINAPI *sp_glGetUniformLocationProc)(GLuint, const GLchar *);
#define glGetUniformLocation(program, name) sp_glGetUniformLocation(program, name)
    
typedef void (WINAPI *sp_glEnableVertexAttribArrayProc)(GLuint);
#define glEnableVertexAttribArray(index) sp_glEnableVertexAttribArray(index)
typedef void (WINAPI *sp_glDisableVertexAttribArrayProc)(GLuint);
#define glDisableVertexAttribArray(index) sp_glDisableVertexAttribArray(index)

typedef void (WINAPI *sp_glUniform1iProc)(GLint, GLint);
#define glUniform1i(location, v0) sp_glUniform1i(location, v0)
typedef void (WINAPI *sp_glUniformMatrix4fvProc)(GLint, GLsizei, GLboolean, const GLfloat *);
#define glUniformMatrix4fv(location, count, transpose, value) sp_glUniformMatrix4fv(location, count, transpose, value)
typedef void (WINAPI *sp_glUniform1fProc)(GLint, GLfloat);
#define glUniform1f(location, v0) sp_glUniform1f(location, v0)
typedef void (WINAPI *sp_glUniform3fvProc)(GLint, GLsizei, const GLfloat *);
#define glUniform3fv(location, count, value) sp_glUniform3fv(location, count, value)
typedef void (WINAPI *sp_glUniform4fvProc)(GLint, GLsizei, const GLfloat *);
#define glUniform4fv(location, count, value) sp_glUniform4fv(location, count, value)

typedef void (WINAPI *sp_glVertexAttribPointerProc)(GLuint, GLint, GLenum, GLboolean, GLsizei, const GLvoid *);
#define glVertexAttribPointer(index, size, type, normalized, stride, pointer) sp_glVertexAttribPointer(index, size, type, normalized, stride, pointer)

typedef GLboolean (WINAPI *sp_glIsBufferProc)(GLuint);
#define glIsBuffer(buffer) sp_glIsBuffer(buffer)
typedef void (WINAPI *sp_glGenBuffersProc)(GLsizei, GLuint *);
#define glGenBuffers(n, buffers) sp_glGenBuffers(n, buffers)
typedef void (WINAPI *sp_glDeleteBuffersProc)(GLsizei, const GLuint *);
#define glDeleteBuffers(n, buffers) sp_glDeleteBuffers(n, buffers)
typedef void (WINAPI *sp_glBindBufferProc)(GLenum, GLuint);
#define glBindBuffer(target, buffer) sp_glBindBuffer(target, buffer)
typedef void (WINAPI *sp_glBufferDataProc)(GLenum, /*GLsizeiptr*/size_t, const GLvoid *, GLenum);
#define glBufferData(target, size, data, usage) sp_glBufferData(target, size, data, usage)
typedef void (WINAPI *sp_glBufferSubDataProc)(GLenum, /*GLintptr*/size_t, /*GLsizeiptr*/size_t, const GLvoid *);
#define glBufferSubData(target, offset, size, data) sp_glBufferSubData(target, offset, size, data)

typedef GLboolean (WINAPI *sp_glIsVertexArrayProc)(GLuint);
#define glIsVertexArray(array) sp_glIsVertexArray(array)
typedef void (WINAPI *sp_glGenVertexArraysProc)(GLsizei, GLuint *);
#define glGenVertexArrays(n, arrays) sp_glGenVertexArrays(n, arrays)
typedef void (WINAPI *sp_glDeleteVertexArraysProc)(GLsizei, const GLuint *);
#define glDeleteVertexArrays(n, arrays) sp_glDeleteVertexArrays(n, arrays)
typedef void (WINAPI *sp_glBindVertexArrayProc)(GLuint);
#define glBindVertexArray(array) sp_glBindVertexArray(array)

extern spBool spInitShaderGLFunctionsWin(HGLRC *global_hglrc);

#ifdef __cplusplus
}  /* Close scope of 'extern "C"' declaration */
#endif

#endif /* __SPGLSHADER_WIN_H */
