/*
 *	spGLString.h
 */

#ifndef __SPGLSTRING_H
#define __SPGLSTRING_H

#include <sp/spGL.h>

#ifdef __cplusplus
extern "C" {
#endif

#define SP_GL_STRING_SHADER_VERSION_MASK 0x7fff
#define SP_GL_STRING_SHADER_VERSION_ES 0x8000

#define SP_GL_STRING_SHADER_VERSION_GLES_2_0 (0x8000|100)
#define SP_GL_STRING_SHADER_VERSION_GLES_3_0 (0x8000|300)
#define SP_GL_STRING_SHADER_VERSION_GLES_3_1 (0x8000|310)
#define SP_GL_STRING_SHADER_VERSION_GL_2_0 (0)
#define SP_GL_STRING_SHADER_VERSION_GL_2_1 (120)
#define SP_GL_STRING_SHADER_VERSION_GL_3_0 (130)
#define SP_GL_STRING_SHADER_VERSION_GL_3_1 (140)
#define SP_GL_STRING_SHADER_VERSION_GL_3_2 (150)
#define SP_GL_STRING_SHADER_VERSION_GL_3_3 (330)
#define SP_GL_STRING_SHADER_VERSION_GL_4_0 (400)
#define SP_GL_STRING_SHADER_VERSION_GL_4_1 (410)
#define SP_GL_STRING_SHADER_VERSION_GL_4_2 (420)
#define SP_GL_STRING_SHADER_VERSION_GL_4_3 (430)
#define SP_GL_STRING_SHADER_VERSION_GL_4_4 (440)
#define SP_GL_STRING_SHADER_VERSION_GL_4_5 (450)

#define SP_GL_STRING_OPTION_NONE 0L
#define SP_GL_STRING_OPTION_USE_TEXTURE (1L<<16)
#define SP_GL_STRING_OPTION_USE_SHADER (1L<<17)
#define SP_GL_STRING_OPTION_USE_VAO (1L<<18)

#if defined(_WIN32) || defined(USE_MOTIF) || defined(GTK) || defined(ANDROID) || defined(COCOA)
#define SP_GL_STRING_BY_TEXTURE 1
#endif

#if defined(SP_GL_STRING_BY_TEXTURE)
typedef struct _spGLTextureInfo *spGLTextureInfo;
typedef struct _spGLTextureLine *spGLTextureLine;
typedef struct _spGLTextureRegion *spGLTextureRegion;
#endif
    
#if defined(MACOS)
#pragma import on
#endif

extern spGLString spCreateGLStringArg(spComponent gldrawable, char *string, spArg *args, int num_arg);
extern spGLString spCreateGLString(spComponent gldrawable, char *string, ...);
extern spBool spDestroyGLString(spGLString glstring);
extern void spSetGLStringParams(spGLString glstring, ...);
extern spBool spGetGLStringExtent(spComponent gldrawable, spGLString glstring,
				  int *x, int *y, int *width, int *height, int *next_x);
extern spBool spSetGLStringPos3f(spGLString glstring, GLfloat x, GLfloat y, GLfloat z);
extern spBool spDrawGLString(spComponent gldrawable, spGLString glstring);

#if defined(MACOS)
#pragma import off
#endif
    
#ifdef __cplusplus
}  /* Close scope of 'extern "C"' declaration */
#endif

#endif /* __SPGLSTRING_H */
