/*
 *	spGLStringP.h
 */

#ifndef __SPGLSTRINGP_H
#define __SPGLSTRINGP_H

#include <sp/spObjectP.h>
#include <sp/spDIBitmap.h>
#include <sp/spGLString.h>
#include <sp/spGLP.h>

#if defined(GTK)
#include <sp/spGLString_Gtk.h>
#elif defined(_WIN32) && !defined(USE_MOTIF)
#include <sp/spGLString_Win.h>
#elif defined(ANDROID)
#include <sp/spGLString_Egl.h>
#elif defined(COCOA)
#include <sp/spGLString_Cocoa.h>
#elif defined(MACOS)
#include <sp/spGLString_Mac.h>
#else
#include <sp/spGLString_Xm.h>
#endif

#ifdef __cplusplus
extern "C" {
#endif

#if defined(SP_GL_STRING_BY_TEXTURE)

#if defined(GTK) && defined(SP_GL_STRING_USE_PANGO)
#if BYTE_ORDER == BIG_ENDIAN
#if defined(GL_ARGB)
#define SP_GL_STRING_BY_TEXTURE_BITMAP_PIXEL_FORMAT GL_ARGB
#define SP_GL_STRING_BY_TEXTURE_BITMAP_DATA_TYPE GL_UNSIGNED_BYTE
#elif defined(GL_ARGB_EXT)
#define SP_GL_STRING_BY_TEXTURE_BITMAP_PIXEL_FORMAT GL_ARGB_EXT
#define SP_GL_STRING_BY_TEXTURE_BITMAP_DATA_TYPE GL_UNSIGNED_BYTE
#else
#define SP_GL_STRING_BY_TEXTURE_BITMAP_PIXEL_FORMAT GL_BGRA
#define SP_GL_STRING_BY_TEXTURE_BITMAP_DATA_TYPE GL_UNSIGNED_INT_8_8_8_8_REV
#endif 
#else /* BYTE_ORDER == BIG_ENDIAN */
#define SP_GL_STRING_BY_TEXTURE_BITMAP_PIXEL_FORMAT GL_BGRA
#define SP_GL_STRING_BY_TEXTURE_BITMAP_DATA_TYPE GL_UNSIGNED_BYTE
#endif /* !(BYTE_ORDER == BIG_ENDIAN) */
#else /* defined(GTK) && defined(SP_GL_STRING_USE_PANGO) */
#define SP_GL_STRING_BY_TEXTURE_BITMAP_PIXEL_FORMAT GL_RGBA
#define SP_GL_STRING_BY_TEXTURE_BITMAP_DATA_TYPE GL_UNSIGNED_BYTE
#endif /* !(defined(GTK) && defined(SP_GL_STRING_USE_PANGO)) */

struct _spGLTextureRegion {
    spGLTextureLine line;

    int x;
    int y;
    int width;
    int height;
    
    GLenum alpha_sfactor;
    GLenum alpha_dfactor;
    
    GLuint vao;
    GLuint uv_vbo;
    
    spGLTextureRegion prev;
    spGLTextureRegion next;
};
    
struct _spGLTextureLine {
    spGLTextureInfo info;
    
    int ypos;
    int height;
    
    spGLTextureRegion first_region;
    spGLTextureRegion last_region;

    spGLTextureLine prev;
    spGLTextureLine next;
};

struct _spGLTextureInfo {
    GLenum texture_unit;
    GLuint texture_name;
    
    int inside_margin_width;
    int inside_margin_height;
    
    int texture_width;
    int texture_height;

    int num_region;

    spBool use_shader;
    
    spBool use_vao;
    GLuint position_vbo;

    spGLTextureLine first_line;
    spGLTextureLine last_line;

    spGLTextureInfo prev;
    spGLTextureInfo next;
};
#endif
    
typedef struct _spGLStringPart {
    spGLStringArchPart arch_part;
    
    spComponent gldrawable;
    
    char *font_name;
    char *foreground;
    spPixel fg_pixel;
    
    spAlignment string_alignment;
    spBool use_anti_alias_font;

    unsigned long options;
    spBool use_texture;
    spBool use_shader;
    GLfloat *projection_matrix;
    GLfloat *modelview_matrix;
    
#if defined(SP_GL_STRING_LIST_BASE)
    GLuint list_base;
    GLuint count;
#endif
    int x;
    int y;
    int width;
    int height;
    int next_x;

    GLfloat pos_x;
    GLfloat pos_y;
    GLfloat pos_z;
} spGLStringPart;

typedef struct _spGLStringRec {
    spObjectPart object;
    spGLStringPart glstring;
} spGLStringRec;

typedef struct _spGLStringClassPart {
    int dummy;
} spGLStringClassPart;
    
typedef struct _spGLStringClassRec {
    spObjectClassPart object;
    spGLStringClassPart glstring;
} spGLStringClassRec;

#if defined(MACOS)
#pragma import on
#endif

extern spGLStringClassRec SpGLStringClassRec;
    
#define SpGLStringPart(obj) (((spGLString)obj)->glstring)
#define SpGLStringArch(obj) (((spGLString)obj)->glstring.arch_part)
#define SpGetGLStringClass(obj) ((spGLStringClass)((obj)->object.object_class))
    
extern void spGLStringPartInit(spObject object);
extern void spGLStringPartFree(spObject object);
extern spBool spGLStringCreate(spObject object);
extern spBool spGLStringDestroy(spObject object);

extern void spGLStringPartInitArch(spGLString glstring);
extern void spGLStringPartFreeArch(spGLString glstring);
extern spBool spGLStringCreateArch(spGLString glstring, char *string);
extern spBool spGLStringDestroyArch(spGLString glstring);
extern spBool spGetGLStringExtentArch(spComponent gldrawable, spGLString glstring);
    
#if defined(SP_GL_STRING_BY_TEXTURE)
extern spDIBitmap spCreateDIBitmapStringArch(spGLString glstring, char *string);
#if defined(SP_GL_STRING_BY_TEXTURE_SUPPORTS_SHADER)
extern spBool spInitGLStringShader(unsigned long options);
#endif
extern spBool spGLStringByTextureCreate(spGLString glstring, char *string);
extern spBool spDestroyGLStringByTexture(spGLString glstring);
extern spBool spDrawGLStringByTexture(spComponent gldrawable, spGLString glstring, GLfloat factor);
#endif
    
#if !(defined(SP_GL_STRING_LIST_BASE) || defined(SP_GL_STRING_BY_TEXTURE))
extern spBool spSetGLStringPos3fArch(spGLString glstring, GLfloat x, GLfloat y, GLfloat z);
#endif
#if !defined(SP_GL_STRING_LIST_BASE) || defined(SP_GL_STRING_BY_TEXTURE)
extern spBool spDrawGLStringArch(spComponent gldrawable, spGLString glstring);
#endif
    
#if defined(GTK) || defined(XmVersion)
extern spBool spGLStringCreateX11(spGLString glstring, char *string);
extern spBool spGLStringDestroyX11(spGLString glstring);
#if defined(SP_GL_STRING_BY_TEXTURE)
extern spDIBitmap spCreateDIBitmapStringX11(spGLString glstring, char *string);
extern spBool spGLStringByTextureDestroyX11(spGLString glstring);
#endif
#endif
    
#if defined(MACOS)
#pragma import off
#endif
    
#ifdef __cplusplus
}  /* Close scope of 'extern "C"' declaration */
#endif

#endif /* __SPGLSTRINGP_H */
