/*
 *	spGLString_Gtk.h
 */

#ifndef __SPGLSTRING_GTK_H
#define __SPGLSTRING_GTK_H

#include <sp/spComponentP.h>

#if !defined(SP_GL_USE_GTK_GL_AREA)
#include <gdk/gdkgl.h>
#include <gtk/gtkgl.h>
#endif

#if GTK_CHECK_VERSION(2,6,0) /*|| PANGO_VERSION_CHECK(1,6,0)*/
#define SP_GL_STRING_USE_PANGO
#endif

#if !defined(SP_GL_STRING_USE_PANGO)
#include <X11/Xlib.h>
#endif

#ifdef __cplusplus
extern "C" {
#endif

#define SP_GL_STRING_LIST_BASE 1
    
#if defined(SP_GL_STRING_BY_TEXTURE)

#define SP_GL_STRING_BY_TEXTURE_SUPPORTS_SHADER
    
#define SP_GL_STRING_BY_TEXTURE_INSIDE_MARGIN_WIDTH (2)
#define SP_GL_STRING_BY_TEXTURE_INSIDE_MARGIN_HEIGHT (2)
    
#define SP_GL_STRING_BY_TEXTURE_MIN_TEXTURE_WIDTH (512)
#define SP_GL_STRING_BY_TEXTURE_MIN_TEXTURE_HEIGHT (512)
#endif
    
typedef struct _spGLStringArchPart {
#if !defined(SP_GL_STRING_USE_PANGO)
    XFontSet font_set;
    int num_font;
    XFontStruct **font_struct_list;
    char **font_name_list;
#endif

#if defined(SP_GL_STRING_BY_TEXTURE)
    int inside_margin_width;
    int inside_margin_height;
    spDIBitmap dibitmap;
    spGLTextureRegion region;
    
#if defined(SP_GL_STRING_USE_PANGO)
    PangoFontDescription *font_desc;
#else
    Pixmap pixmap;
    GC gc;
#endif
#endif
} spGLStringArchPart;

#ifdef __cplusplus
}  /* Close scope of 'extern "C"' declaration */
#endif

#endif /* __SPGLSTRING_GTK_H */
