/*
 *	spGLString_Win.h
 */

#ifndef __SPGLSTRING_WIN_H
#define __SPGLSTRING_WIN_H

#include <windows.h>
#include <sp/spGraphics.h>

#ifdef __cplusplus
extern "C" {
#endif

#define SP_GL_STRING_LIST_BASE 1

#if defined(SP_GL_STRING_BY_TEXTURE)
#define SP_GL_STRING_BY_TEXTURE_SUPPORTS_SHADER
    
#define SP_GL_STRING_BY_TEXTURE_INSIDE_MARGIN_WIDTH (2)
#define SP_GL_STRING_BY_TEXTURE_INSIDE_MARGIN_HEIGHT (2)
    
#define SP_GL_STRING_BY_TEXTURE_MIN_TEXTURE_WIDTH (512)
#define SP_GL_STRING_BY_TEXTURE_MIN_TEXTURE_HEIGHT (512)
#endif
    
typedef struct _spGLStringArchPart {
#if defined(SP_GL_STRING_BY_TEXTURE)
    int inside_margin_width;
    int inside_margin_height;
    spDIBitmap dibitmap;
    spGLTextureRegion region;
#else
    int dummy;
#endif
} spGLStringArchPart;

#ifdef __cplusplus
}  /* Close scope of 'extern "C"' declaration */
#endif

#endif /* __SPGLSTRING_WIN_H */
