/*
 *	spGLString_Xm.h
 */

#ifndef __SPGLSTRING_XM_H
#define __SPGLSTRING_XM_H

#include <X11/Xlib.h>
#include <GL/glx.h> 

#ifdef __cplusplus
extern "C" {
#endif

#define SP_GL_STRING_LIST_BASE 1
    
#if defined(SP_GL_STRING_BY_TEXTURE)
#define SP_GL_STRING_BY_TEXTURE_SUPPORTS_SHADER
    
#define SP_GL_STRING_BY_TEXTURE_INSIDE_MARGIN_WIDTH (2)
#define SP_GL_STRING_BY_TEXTURE_INSIDE_MARGIN_HEIGHT (2)
    
#define SP_GL_STRING_BY_TEXTURE_MIN_TEXTURE_WIDTH (512)
#define SP_GL_STRING_BY_TEXTURE_MIN_TEXTURE_HEIGHT (512)
#endif
    
typedef struct _spGLStringArchPart {
    XFontSet font_set;
    int num_font;
    XFontStruct **font_struct_list;
    char **font_name_list;

#if defined(SP_GL_STRING_BY_TEXTURE)
    int inside_margin_width;
    int inside_margin_height;
    spDIBitmap dibitmap;
    spGLTextureRegion region;
    
    Pixmap pixmap;
    GC gc;
#endif
} spGLStringArchPart;

#ifdef __cplusplus
}  /* Close scope of 'extern "C"' declaration */
#endif

#endif /* __SPGLSTRING_XM_H */
